/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.file;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.file.codec.FileUpdateTransactionBodyJsonCodec;
import com.hedera.hapi.node.file.codec.FileUpdateTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record FileUpdateTransactionBody(@Nullable FileID fileID, @Nullable Timestamp expirationTime, @Nullable KeyList keys, Bytes contents, @Nullable String memo) {
    public static final Codec<FileUpdateTransactionBody> PROTOBUF = new FileUpdateTransactionBodyProtoCodec();
    public static final JsonCodec<FileUpdateTransactionBody> JSON = new FileUpdateTransactionBodyJsonCodec();
    public static final FileUpdateTransactionBody DEFAULT = FileUpdateTransactionBody.newBuilder().build();

    public boolean hasFileID() {
        return this.fileID != null;
    }

    public FileID fileIDOrElse(@NonNull FileID defaultValue) {
        return this.hasFileID() ? this.fileID : defaultValue;
    }

    @NonNull
    public FileID fileIDOrThrow() {
        return Objects.requireNonNull(this.fileID, "Field fileID is null");
    }

    public void ifFileID(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasFileID()) {
            ifPresent.accept(this.fileID);
        }
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public boolean hasKeys() {
        return this.keys != null;
    }

    public KeyList keysOrElse(@NonNull KeyList defaultValue) {
        return this.hasKeys() ? this.keys : defaultValue;
    }

    @NonNull
    public KeyList keysOrThrow() {
        return Objects.requireNonNull(this.keys, "Field keys is null");
    }

    public void ifKeys(@NonNull Consumer<KeyList> ifPresent) {
        if (this.hasKeys()) {
            ifPresent.accept(this.keys);
        }
    }

    public boolean hasMemo() {
        return this.memo != null;
    }

    public String memoOrElse(@NonNull String defaultValue) {
        return this.hasMemo() ? this.memo : defaultValue;
    }

    @NonNull
    public String memoOrThrow() {
        return Objects.requireNonNull(this.memo, "Field memo is null");
    }

    public void ifMemo(@NonNull Consumer<String> ifPresent) {
        if (this.hasMemo()) {
            ifPresent.accept(this.memo);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.fileID, this.expirationTime, this.keys, this.contents, this.memo);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private FileID fileID = null;
        private Timestamp expirationTime = null;
        private KeyList keys = null;
        private Bytes contents = Bytes.EMPTY;
        private String memo = null;

        public Builder() {
        }

        public Builder(FileID fileID, Timestamp expirationTime, KeyList keys, Bytes contents, String memo) {
            this.fileID = fileID;
            this.expirationTime = expirationTime;
            this.keys = keys;
            this.contents = contents;
            this.memo = memo;
        }

        public FileUpdateTransactionBody build() {
            return new FileUpdateTransactionBody(this.fileID, this.expirationTime, this.keys, this.contents, this.memo);
        }

        public Builder fileID(FileID fileID) {
            this.fileID = fileID;
            return this;
        }

        public Builder fileID(FileID.Builder builder) {
            this.fileID = builder.build();
            return this;
        }

        public Builder expirationTime(Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder keys(KeyList keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(KeyList.Builder builder) {
            this.keys = builder.build();
            return this;
        }

        public Builder contents(Bytes contents) {
            this.contents = contents;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }
    }
}

