/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.file;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.file.codec.SystemDeleteTransactionBodyJsonCodec;
import com.hedera.hapi.node.file.codec.SystemDeleteTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.OneOf;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record SystemDeleteTransactionBody(OneOf<IdOneOfType> id, @Nullable TimestampSeconds expirationTime) {
    public static final Codec<SystemDeleteTransactionBody> PROTOBUF = new SystemDeleteTransactionBodyProtoCodec();
    public static final JsonCodec<SystemDeleteTransactionBody> JSON = new SystemDeleteTransactionBodyJsonCodec();
    public static final SystemDeleteTransactionBody DEFAULT = SystemDeleteTransactionBody.newBuilder().build();

    public SystemDeleteTransactionBody {
        if (id == null) {
            throw new NullPointerException("Parameter 'id' must be supplied and can not be null");
        }
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public TimestampSeconds expirationTimeOrElse(@NonNull TimestampSeconds defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public TimestampSeconds expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<TimestampSeconds> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    @Nullable
    public FileID fileID() {
        return this.id.kind() == IdOneOfType.FILE_ID ? (FileID)this.id.value() : null;
    }

    public boolean hasFileID() {
        return this.id.kind() == IdOneOfType.FILE_ID;
    }

    public FileID fileIDOrElse(@NonNull FileID defaultValue) {
        return this.hasFileID() ? this.fileID() : defaultValue;
    }

    @NonNull
    public FileID fileIDOrThrow() {
        return Objects.requireNonNull(this.fileID(), "Field fileID is null");
    }

    @Nullable
    public ContractID contractID() {
        return this.id.kind() == IdOneOfType.CONTRACT_ID ? (ContractID)this.id.value() : null;
    }

    public boolean hasContractID() {
        return this.id.kind() == IdOneOfType.CONTRACT_ID;
    }

    public ContractID contractIDOrElse(@NonNull ContractID defaultValue) {
        return this.hasContractID() ? this.contractID() : defaultValue;
    }

    @NonNull
    public ContractID contractIDOrThrow() {
        return Objects.requireNonNull(this.contractID(), "Field contractID is null");
    }

    public Builder copyBuilder() {
        return new Builder(this.id, this.expirationTime);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static enum IdOneOfType implements EnumWithProtoMetadata
    {
        UNSET(-1, "UNSET"),
        FILE_ID(1, "fileID"),
        CONTRACT_ID(2, "contractID");

        private final int protoOrdinal;
        private final String protoName;

        private IdOneOfType(int protoOrdinal, String protoName) {
            this.protoOrdinal = protoOrdinal;
            this.protoName = protoName;
        }

        public int protoOrdinal() {
            return this.protoOrdinal;
        }

        public String protoName() {
            return this.protoName;
        }

        public static IdOneOfType fromProtobufOrdinal(int ordinal) {
            return switch (ordinal) {
                case 1 -> FILE_ID;
                case 2 -> CONTRACT_ID;
                default -> throw new IllegalArgumentException("Unknown protobuf ordinal " + ordinal);
            };
        }

        public static IdOneOfType fromString(String name) {
            return switch (name) {
                case "FILE_ID", "fileID" -> FILE_ID;
                case "CONTRACT_ID", "contractID" -> CONTRACT_ID;
                default -> throw new IllegalArgumentException("Unknown token kyc status " + name);
            };
        }
    }

    public static final class Builder {
        private OneOf<IdOneOfType> id = SystemDeleteTransactionBodyProtoCodec.ID_UNSET;
        private TimestampSeconds expirationTime = null;

        public Builder() {
        }

        public Builder(OneOf<IdOneOfType> id, TimestampSeconds expirationTime) {
            this.id = id;
            this.expirationTime = expirationTime;
        }

        public SystemDeleteTransactionBody build() {
            return new SystemDeleteTransactionBody(this.id, this.expirationTime);
        }

        public Builder fileID(FileID fileID) {
            this.id = new OneOf((Object)IdOneOfType.FILE_ID, (Object)fileID);
            return this;
        }

        public Builder fileID(FileID.Builder builder) {
            this.id = new OneOf((Object)IdOneOfType.FILE_ID, (Object)builder.build());
            return this;
        }

        public Builder contractID(ContractID contractID) {
            this.id = new OneOf((Object)IdOneOfType.CONTRACT_ID, (Object)contractID);
            return this;
        }

        public Builder contractID(ContractID.Builder builder) {
            this.id = new OneOf((Object)IdOneOfType.CONTRACT_ID, (Object)builder.build());
            return this;
        }

        public Builder expirationTime(TimestampSeconds expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(TimestampSeconds.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }
    }
}

