/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.file.codec;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.file.FileAppendTransactionBody;
import com.hedera.hapi.node.file.schema.FileAppendTransactionBodySchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class FileAppendTransactionBodyProtoCodec
implements Codec<FileAppendTransactionBody> {
    @NonNull
    public FileAppendTransactionBody parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public FileAppendTransactionBody parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull FileAppendTransactionBody data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FileAppendTransactionBodySchema.FILE_ID, (Object)data.fileID(), (arg_0, arg_1) -> FileID.PROTOBUF.write(arg_0, arg_1), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)FileAppendTransactionBodySchema.CONTENTS, (RandomAccessData)data.contents());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(FileAppendTransactionBody data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FileAppendTransactionBodySchema.FILE_ID, (Object)data.fileID(), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)FileAppendTransactionBodySchema.CONTENTS, (RandomAccessData)data.contents());
    }

    public boolean fastEquals(@NonNull FileAppendTransactionBody item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private FileAppendTransactionBody parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        FileID temp_fileID = null;
        Bytes temp_contents = Bytes.EMPTY;
        try {
            block6: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = FileAppendTransactionBodySchema.getField(field);
                switch (tag) {
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        FileID value = strictMode ? (FileID)FileID.PROTOBUF.parseStrict(input) : (FileID)FileID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_fileID = value;
                        continue block6;
                    }
                    case 34: {
                        Bytes value;
                        temp_contents = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block6;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new FileAppendTransactionBody(temp_fileID, temp_contents);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new FileAppendTransactionBody(temp_fileID, temp_contents);
    }
}

