/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.freeze;

import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.freeze.FreezeType;
import com.hedera.hapi.node.freeze.codec.FreezeTransactionBodyJsonCodec;
import com.hedera.hapi.node.freeze.codec.FreezeTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record FreezeTransactionBody(int startHour, int startMin, int endHour, int endMin, @Nullable FileID updateFile, Bytes fileHash, @Nullable Timestamp startTime, FreezeType freezeType) {
    public static final Codec<FreezeTransactionBody> PROTOBUF = new FreezeTransactionBodyProtoCodec();
    public static final JsonCodec<FreezeTransactionBody> JSON = new FreezeTransactionBodyJsonCodec();
    public static final FreezeTransactionBody DEFAULT = FreezeTransactionBody.newBuilder().build();

    public boolean hasUpdateFile() {
        return this.updateFile != null;
    }

    public FileID updateFileOrElse(@NonNull FileID defaultValue) {
        return this.hasUpdateFile() ? this.updateFile : defaultValue;
    }

    @NonNull
    public FileID updateFileOrThrow() {
        return Objects.requireNonNull(this.updateFile, "Field updateFile is null");
    }

    public void ifUpdateFile(@NonNull Consumer<FileID> ifPresent) {
        if (this.hasUpdateFile()) {
            ifPresent.accept(this.updateFile);
        }
    }

    public boolean hasStartTime() {
        return this.startTime != null;
    }

    public Timestamp startTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasStartTime() ? this.startTime : defaultValue;
    }

    @NonNull
    public Timestamp startTimeOrThrow() {
        return Objects.requireNonNull(this.startTime, "Field startTime is null");
    }

    public void ifStartTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasStartTime()) {
            ifPresent.accept(this.startTime);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.startHour, this.startMin, this.endHour, this.endMin, this.updateFile, this.fileHash, this.startTime, this.freezeType);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private int startHour = 0;
        private int startMin = 0;
        private int endHour = 0;
        private int endMin = 0;
        private FileID updateFile = null;
        private Bytes fileHash = Bytes.EMPTY;
        private Timestamp startTime = null;
        private FreezeType freezeType = FreezeType.values()[0];

        public Builder() {
        }

        public Builder(int startHour, int startMin, int endHour, int endMin, FileID updateFile, Bytes fileHash, Timestamp startTime, FreezeType freezeType) {
            this.startHour = startHour;
            this.startMin = startMin;
            this.endHour = endHour;
            this.endMin = endMin;
            this.updateFile = updateFile;
            this.fileHash = fileHash;
            this.startTime = startTime;
            this.freezeType = freezeType;
        }

        public FreezeTransactionBody build() {
            return new FreezeTransactionBody(this.startHour, this.startMin, this.endHour, this.endMin, this.updateFile, this.fileHash, this.startTime, this.freezeType);
        }

        public Builder startHour(int startHour) {
            this.startHour = startHour;
            return this;
        }

        public Builder startMin(int startMin) {
            this.startMin = startMin;
            return this;
        }

        public Builder endHour(int endHour) {
            this.endHour = endHour;
            return this;
        }

        public Builder endMin(int endMin) {
            this.endMin = endMin;
            return this;
        }

        public Builder updateFile(FileID updateFile) {
            this.updateFile = updateFile;
            return this;
        }

        public Builder updateFile(FileID.Builder builder) {
            this.updateFile = builder.build();
            return this;
        }

        public Builder fileHash(Bytes fileHash) {
            this.fileHash = fileHash;
            return this;
        }

        public Builder startTime(Timestamp startTime) {
            this.startTime = startTime;
            return this;
        }

        public Builder startTime(Timestamp.Builder builder) {
            this.startTime = builder.build();
            return this;
        }

        public Builder freezeType(FreezeType freezeType) {
            this.freezeType = freezeType;
            return this;
        }
    }
}

