/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.scheduled;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.scheduled.codec.ScheduleCreateTransactionBodyJsonCodec;
import com.hedera.hapi.node.scheduled.codec.ScheduleCreateTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ScheduleCreateTransactionBody(@Nullable SchedulableTransactionBody scheduledTransactionBody, String memo, @Nullable Key adminKey, @Nullable AccountID payerAccountID, @Nullable Timestamp expirationTime, boolean waitForExpiry) {
    public static final Codec<ScheduleCreateTransactionBody> PROTOBUF = new ScheduleCreateTransactionBodyProtoCodec();
    public static final JsonCodec<ScheduleCreateTransactionBody> JSON = new ScheduleCreateTransactionBodyJsonCodec();
    public static final ScheduleCreateTransactionBody DEFAULT = ScheduleCreateTransactionBody.newBuilder().build();

    public boolean hasScheduledTransactionBody() {
        return this.scheduledTransactionBody != null;
    }

    public SchedulableTransactionBody scheduledTransactionBodyOrElse(@NonNull SchedulableTransactionBody defaultValue) {
        return this.hasScheduledTransactionBody() ? this.scheduledTransactionBody : defaultValue;
    }

    @NonNull
    public SchedulableTransactionBody scheduledTransactionBodyOrThrow() {
        return Objects.requireNonNull(this.scheduledTransactionBody, "Field scheduledTransactionBody is null");
    }

    public void ifScheduledTransactionBody(@NonNull Consumer<SchedulableTransactionBody> ifPresent) {
        if (this.hasScheduledTransactionBody()) {
            ifPresent.accept(this.scheduledTransactionBody);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasPayerAccountID() {
        return this.payerAccountID != null;
    }

    public AccountID payerAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasPayerAccountID() ? this.payerAccountID : defaultValue;
    }

    @NonNull
    public AccountID payerAccountIDOrThrow() {
        return Objects.requireNonNull(this.payerAccountID, "Field payerAccountID is null");
    }

    public void ifPayerAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasPayerAccountID()) {
            ifPresent.accept(this.payerAccountID);
        }
    }

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public Timestamp expirationTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public Timestamp expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.scheduledTransactionBody, this.memo, this.adminKey, this.payerAccountID, this.expirationTime, this.waitForExpiry);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private SchedulableTransactionBody scheduledTransactionBody = null;
        private String memo = "";
        private Key adminKey = null;
        private AccountID payerAccountID = null;
        private Timestamp expirationTime = null;
        private boolean waitForExpiry = false;

        public Builder() {
        }

        public Builder(SchedulableTransactionBody scheduledTransactionBody, String memo, Key adminKey, AccountID payerAccountID, Timestamp expirationTime, boolean waitForExpiry) {
            this.scheduledTransactionBody = scheduledTransactionBody;
            this.memo = memo;
            this.adminKey = adminKey;
            this.payerAccountID = payerAccountID;
            this.expirationTime = expirationTime;
            this.waitForExpiry = waitForExpiry;
        }

        public ScheduleCreateTransactionBody build() {
            return new ScheduleCreateTransactionBody(this.scheduledTransactionBody, this.memo, this.adminKey, this.payerAccountID, this.expirationTime, this.waitForExpiry);
        }

        public Builder scheduledTransactionBody(SchedulableTransactionBody scheduledTransactionBody) {
            this.scheduledTransactionBody = scheduledTransactionBody;
            return this;
        }

        public Builder scheduledTransactionBody(SchedulableTransactionBody.Builder builder) {
            this.scheduledTransactionBody = builder.build();
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder adminKey(Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder payerAccountID(AccountID payerAccountID) {
            this.payerAccountID = payerAccountID;
            return this;
        }

        public Builder payerAccountID(AccountID.Builder builder) {
            this.payerAccountID = builder.build();
            return this;
        }

        public Builder expirationTime(Timestamp expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(Timestamp.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }

        public Builder waitForExpiry(boolean waitForExpiry) {
            this.waitForExpiry = waitForExpiry;
            return this;
        }
    }
}

