/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.contract.codec;

import com.hedera.hapi.node.state.contract.Bytecode;
import com.hedera.hapi.node.state.contract.schema.BytecodeSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class BytecodeProtoCodec
implements Codec<Bytecode> {
    @NonNull
    public Bytecode parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public Bytecode parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull Bytecode data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)BytecodeSchema.CODE, (RandomAccessData)data.code());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Bytecode data) {
        int size = 0;
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)BytecodeSchema.CODE, (RandomAccessData)data.code());
    }

    public boolean fastEquals(@NonNull Bytecode item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private Bytecode parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Bytes temp_code = Bytes.EMPTY;
        try {
            block5: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = BytecodeSchema.getField(field);
                switch (tag) {
                    case 10: {
                        Bytes value;
                        temp_code = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block5;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new Bytecode(temp_code);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new Bytecode(temp_code);
    }
}

