/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.contract.codec;

import com.hedera.hapi.node.state.contract.SlotValue;
import com.hedera.hapi.node.state.contract.schema.SlotValueSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class SlotValueProtoCodec
implements Codec<SlotValue> {
    @NonNull
    public SlotValue parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public SlotValue parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull SlotValue data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SlotValueSchema.VALUE, (RandomAccessData)data.value());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SlotValueSchema.PREVIOUS_KEY, (RandomAccessData)data.previousKey());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SlotValueSchema.NEXT_KEY, (RandomAccessData)data.nextKey());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(SlotValue data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SlotValueSchema.VALUE, (RandomAccessData)data.value());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SlotValueSchema.PREVIOUS_KEY, (RandomAccessData)data.previousKey());
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SlotValueSchema.NEXT_KEY, (RandomAccessData)data.nextKey());
    }

    public boolean fastEquals(@NonNull SlotValue item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private SlotValue parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Bytes temp_value = Bytes.EMPTY;
        Bytes temp_previous_key = Bytes.EMPTY;
        Bytes temp_next_key = Bytes.EMPTY;
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = SlotValueSchema.getField(field);
                switch (tag) {
                    case 10: {
                        Bytes value;
                        temp_value = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 18: {
                        Bytes value;
                        temp_previous_key = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 26: {
                        Bytes value;
                        temp_next_key = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new SlotValue(temp_value, temp_previous_key, temp_next_key);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new SlotValue(temp_value, temp_previous_key, temp_next_key);
    }
}

