/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.recordcache.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.state.recordcache.TransactionRecordEntry;
import com.hedera.hapi.node.state.recordcache.schema.TransactionRecordEntrySchema;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class TransactionRecordEntryProtoCodec
implements Codec<TransactionRecordEntry> {
    @NonNull
    public TransactionRecordEntry parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public TransactionRecordEntry parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull TransactionRecordEntry data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TransactionRecordEntrySchema.NODE_ID, (long)data.nodeId());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordEntrySchema.PAYER_ACCOUNT_ID, (Object)data.payerAccountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordEntrySchema.TRANSACTION_RECORD, (Object)data.transactionRecord(), (arg_0, arg_1) -> TransactionRecord.PROTOBUF.write(arg_0, arg_1), arg_0 -> TransactionRecord.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(TransactionRecordEntry data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TransactionRecordEntrySchema.NODE_ID, (long)data.nodeId());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordEntrySchema.PAYER_ACCOUNT_ID, (Object)data.payerAccountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordEntrySchema.TRANSACTION_RECORD, (Object)data.transactionRecord(), arg_0 -> TransactionRecord.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull TransactionRecordEntry item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private TransactionRecordEntry parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        long temp_node_id = 0L;
        Record temp_payer_account_id = null;
        Record temp_transaction_record = null;
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TransactionRecordEntrySchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_node_id = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_payer_account_id = value;
                        continue block7;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TransactionRecord)TransactionRecord.PROTOBUF.parseStrict(input) : (TransactionRecord)TransactionRecord.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_transaction_record = value;
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new TransactionRecordEntry(temp_node_id, (AccountID)temp_payer_account_id, (TransactionRecord)temp_transaction_record);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new TransactionRecordEntry(temp_node_id, (AccountID)temp_payer_account_id, (TransactionRecord)temp_transaction_record);
    }
}

