/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.schedule;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.state.schedule.codec.ScheduleJsonCodec;
import com.hedera.hapi.node.state.schedule.codec.ScheduleProtoCodec;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record Schedule(@Nullable ScheduleID scheduleId, boolean deleted, boolean executed, boolean waitForExpiry, String memo, @Nullable AccountID schedulerAccountId, @Nullable AccountID payerAccountId, @Nullable Key adminKey, @Nullable Timestamp scheduleValidStart, long providedExpirationSecond, long calculatedExpirationSecond, @Nullable Timestamp resolutionTime, @Nullable SchedulableTransactionBody scheduledTransaction, @Nullable TransactionBody originalCreateTransaction, @Nullable List<Key> signatories) {
    public static final Codec<Schedule> PROTOBUF = new ScheduleProtoCodec();
    public static final JsonCodec<Schedule> JSON = new ScheduleJsonCodec();
    public static final Schedule DEFAULT = Schedule.newBuilder().build();

    public boolean hasScheduleId() {
        return this.scheduleId != null;
    }

    public ScheduleID scheduleIdOrElse(@NonNull ScheduleID defaultValue) {
        return this.hasScheduleId() ? this.scheduleId : defaultValue;
    }

    @NonNull
    public ScheduleID scheduleIdOrThrow() {
        return Objects.requireNonNull(this.scheduleId, "Field scheduleId is null");
    }

    public void ifScheduleId(@NonNull Consumer<ScheduleID> ifPresent) {
        if (this.hasScheduleId()) {
            ifPresent.accept(this.scheduleId);
        }
    }

    public boolean hasSchedulerAccountId() {
        return this.schedulerAccountId != null;
    }

    public AccountID schedulerAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSchedulerAccountId() ? this.schedulerAccountId : defaultValue;
    }

    @NonNull
    public AccountID schedulerAccountIdOrThrow() {
        return Objects.requireNonNull(this.schedulerAccountId, "Field schedulerAccountId is null");
    }

    public void ifSchedulerAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSchedulerAccountId()) {
            ifPresent.accept(this.schedulerAccountId);
        }
    }

    public boolean hasPayerAccountId() {
        return this.payerAccountId != null;
    }

    public AccountID payerAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasPayerAccountId() ? this.payerAccountId : defaultValue;
    }

    @NonNull
    public AccountID payerAccountIdOrThrow() {
        return Objects.requireNonNull(this.payerAccountId, "Field payerAccountId is null");
    }

    public void ifPayerAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasPayerAccountId()) {
            ifPresent.accept(this.payerAccountId);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasScheduleValidStart() {
        return this.scheduleValidStart != null;
    }

    public Timestamp scheduleValidStartOrElse(@NonNull Timestamp defaultValue) {
        return this.hasScheduleValidStart() ? this.scheduleValidStart : defaultValue;
    }

    @NonNull
    public Timestamp scheduleValidStartOrThrow() {
        return Objects.requireNonNull(this.scheduleValidStart, "Field scheduleValidStart is null");
    }

    public void ifScheduleValidStart(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasScheduleValidStart()) {
            ifPresent.accept(this.scheduleValidStart);
        }
    }

    public boolean hasResolutionTime() {
        return this.resolutionTime != null;
    }

    public Timestamp resolutionTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasResolutionTime() ? this.resolutionTime : defaultValue;
    }

    @NonNull
    public Timestamp resolutionTimeOrThrow() {
        return Objects.requireNonNull(this.resolutionTime, "Field resolutionTime is null");
    }

    public void ifResolutionTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasResolutionTime()) {
            ifPresent.accept(this.resolutionTime);
        }
    }

    public boolean hasScheduledTransaction() {
        return this.scheduledTransaction != null;
    }

    public SchedulableTransactionBody scheduledTransactionOrElse(@NonNull SchedulableTransactionBody defaultValue) {
        return this.hasScheduledTransaction() ? this.scheduledTransaction : defaultValue;
    }

    @NonNull
    public SchedulableTransactionBody scheduledTransactionOrThrow() {
        return Objects.requireNonNull(this.scheduledTransaction, "Field scheduledTransaction is null");
    }

    public void ifScheduledTransaction(@NonNull Consumer<SchedulableTransactionBody> ifPresent) {
        if (this.hasScheduledTransaction()) {
            ifPresent.accept(this.scheduledTransaction);
        }
    }

    public boolean hasOriginalCreateTransaction() {
        return this.originalCreateTransaction != null;
    }

    public TransactionBody originalCreateTransactionOrElse(@NonNull TransactionBody defaultValue) {
        return this.hasOriginalCreateTransaction() ? this.originalCreateTransaction : defaultValue;
    }

    @NonNull
    public TransactionBody originalCreateTransactionOrThrow() {
        return Objects.requireNonNull(this.originalCreateTransaction, "Field originalCreateTransaction is null");
    }

    public void ifOriginalCreateTransaction(@NonNull Consumer<TransactionBody> ifPresent) {
        if (this.hasOriginalCreateTransaction()) {
            ifPresent.accept(this.originalCreateTransaction);
        }
    }

    public boolean hasSignatories() {
        return this.signatories != null;
    }

    public List<Key> signatoriesOrElse(@NonNull List<Key> defaultValue) {
        return this.hasSignatories() ? this.signatories : defaultValue;
    }

    @NonNull
    public List<Key> signatoriesOrThrow() {
        return Objects.requireNonNull(this.signatories, "Field signatories is null");
    }

    public void ifSignatories(@NonNull Consumer<List<Key>> ifPresent) {
        if (this.hasSignatories()) {
            ifPresent.accept(this.signatories);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.scheduleId, this.deleted, this.executed, this.waitForExpiry, this.memo, this.schedulerAccountId, this.payerAccountId, this.adminKey, this.scheduleValidStart, this.providedExpirationSecond, this.calculatedExpirationSecond, this.resolutionTime, this.scheduledTransaction, this.originalCreateTransaction, this.signatories);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private ScheduleID scheduleId = null;
        private boolean deleted = false;
        private boolean executed = false;
        private boolean waitForExpiry = false;
        private String memo = "";
        private AccountID schedulerAccountId = null;
        private AccountID payerAccountId = null;
        private Key adminKey = null;
        private Timestamp scheduleValidStart = null;
        private long providedExpirationSecond = 0L;
        private long calculatedExpirationSecond = 0L;
        private Timestamp resolutionTime = null;
        private SchedulableTransactionBody scheduledTransaction = null;
        private TransactionBody originalCreateTransaction = null;
        private List<Key> signatories = Collections.emptyList();

        public Builder() {
        }

        public Builder(ScheduleID scheduleId, boolean deleted, boolean executed, boolean waitForExpiry, String memo, AccountID schedulerAccountId, AccountID payerAccountId, Key adminKey, Timestamp scheduleValidStart, long providedExpirationSecond, long calculatedExpirationSecond, Timestamp resolutionTime, SchedulableTransactionBody scheduledTransaction, TransactionBody originalCreateTransaction, List<Key> signatories) {
            this.scheduleId = scheduleId;
            this.deleted = deleted;
            this.executed = executed;
            this.waitForExpiry = waitForExpiry;
            this.memo = memo;
            this.schedulerAccountId = schedulerAccountId;
            this.payerAccountId = payerAccountId;
            this.adminKey = adminKey;
            this.scheduleValidStart = scheduleValidStart;
            this.providedExpirationSecond = providedExpirationSecond;
            this.calculatedExpirationSecond = calculatedExpirationSecond;
            this.resolutionTime = resolutionTime;
            this.scheduledTransaction = scheduledTransaction;
            this.originalCreateTransaction = originalCreateTransaction;
            this.signatories = signatories;
        }

        public Schedule build() {
            return new Schedule(this.scheduleId, this.deleted, this.executed, this.waitForExpiry, this.memo, this.schedulerAccountId, this.payerAccountId, this.adminKey, this.scheduleValidStart, this.providedExpirationSecond, this.calculatedExpirationSecond, this.resolutionTime, this.scheduledTransaction, this.originalCreateTransaction, this.signatories);
        }

        public Builder scheduleId(ScheduleID scheduleId) {
            this.scheduleId = scheduleId;
            return this;
        }

        public Builder scheduleId(ScheduleID.Builder builder) {
            this.scheduleId = builder.build();
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder executed(boolean executed) {
            this.executed = executed;
            return this;
        }

        public Builder waitForExpiry(boolean waitForExpiry) {
            this.waitForExpiry = waitForExpiry;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder schedulerAccountId(AccountID schedulerAccountId) {
            this.schedulerAccountId = schedulerAccountId;
            return this;
        }

        public Builder schedulerAccountId(AccountID.Builder builder) {
            this.schedulerAccountId = builder.build();
            return this;
        }

        public Builder payerAccountId(AccountID payerAccountId) {
            this.payerAccountId = payerAccountId;
            return this;
        }

        public Builder payerAccountId(AccountID.Builder builder) {
            this.payerAccountId = builder.build();
            return this;
        }

        public Builder adminKey(Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder scheduleValidStart(Timestamp scheduleValidStart) {
            this.scheduleValidStart = scheduleValidStart;
            return this;
        }

        public Builder scheduleValidStart(Timestamp.Builder builder) {
            this.scheduleValidStart = builder.build();
            return this;
        }

        public Builder providedExpirationSecond(long providedExpirationSecond) {
            this.providedExpirationSecond = providedExpirationSecond;
            return this;
        }

        public Builder calculatedExpirationSecond(long calculatedExpirationSecond) {
            this.calculatedExpirationSecond = calculatedExpirationSecond;
            return this;
        }

        public Builder resolutionTime(Timestamp resolutionTime) {
            this.resolutionTime = resolutionTime;
            return this;
        }

        public Builder resolutionTime(Timestamp.Builder builder) {
            this.resolutionTime = builder.build();
            return this;
        }

        public Builder scheduledTransaction(SchedulableTransactionBody scheduledTransaction) {
            this.scheduledTransaction = scheduledTransaction;
            return this;
        }

        public Builder scheduledTransaction(SchedulableTransactionBody.Builder builder) {
            this.scheduledTransaction = builder.build();
            return this;
        }

        public Builder originalCreateTransaction(TransactionBody originalCreateTransaction) {
            this.originalCreateTransaction = originalCreateTransaction;
            return this;
        }

        public Builder originalCreateTransaction(TransactionBody.Builder builder) {
            this.originalCreateTransaction = builder.build();
            return this;
        }

        public Builder signatories(List<Key> signatories) {
            this.signatories = signatories;
            return this;
        }

        public Builder signatories(Key ... values) {
            this.signatories = List.of(values);
            return this;
        }
    }
}

