/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.schedule;

import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.schedule.codec.ScheduleListJsonCodec;
import com.hedera.hapi.node.state.schedule.codec.ScheduleListProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record ScheduleList(@Nullable List<Schedule> schedules) {
    public static final Codec<ScheduleList> PROTOBUF = new ScheduleListProtoCodec();
    public static final JsonCodec<ScheduleList> JSON = new ScheduleListJsonCodec();
    public static final ScheduleList DEFAULT = ScheduleList.newBuilder().build();

    public boolean hasSchedules() {
        return this.schedules != null;
    }

    public List<Schedule> schedulesOrElse(@NonNull List<Schedule> defaultValue) {
        return this.hasSchedules() ? this.schedules : defaultValue;
    }

    @NonNull
    public List<Schedule> schedulesOrThrow() {
        return Objects.requireNonNull(this.schedules, "Field schedules is null");
    }

    public void ifSchedules(@NonNull Consumer<List<Schedule>> ifPresent) {
        if (this.hasSchedules()) {
            ifPresent.accept(this.schedules);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.schedules);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Schedule> schedules = Collections.emptyList();

        public Builder() {
        }

        public Builder(List<Schedule> schedules) {
            this.schedules = schedules;
        }

        public ScheduleList build() {
            return new ScheduleList(this.schedules);
        }

        public Builder schedules(List<Schedule> schedules) {
            this.schedules = schedules;
            return this;
        }

        public Builder schedules(Schedule ... values) {
            this.schedules = List.of(values);
            return this;
        }
    }
}

