/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.schedule.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.schedule.schema.ScheduleSchema;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class ScheduleProtoCodec
implements Codec<Schedule> {
    @NonNull
    public Schedule parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public Schedule parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull Schedule data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.SCHEDULE_ID, (Object)data.scheduleId(), (arg_0, arg_1) -> ScheduleID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ScheduleID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.DELETED, (boolean)data.deleted());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.EXECUTED, (boolean)data.executed());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.WAIT_FOR_EXPIRY, (boolean)data.waitForExpiry());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.SCHEDULER_ACCOUNT_ID, (Object)data.schedulerAccountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.PAYER_ACCOUNT_ID, (Object)data.payerAccountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.ADMIN_KEY, (Object)data.adminKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.SCHEDULE_VALID_START, (Object)data.scheduleValidStart(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.PROVIDED_EXPIRATION_SECOND, (long)data.providedExpirationSecond());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.CALCULATED_EXPIRATION_SECOND, (long)data.calculatedExpirationSecond());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.RESOLUTION_TIME, (Object)data.resolutionTime(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.SCHEDULED_TRANSACTION, (Object)data.scheduledTransaction(), (arg_0, arg_1) -> SchedulableTransactionBody.PROTOBUF.write(arg_0, arg_1), arg_0 -> SchedulableTransactionBody.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.ORIGINAL_CREATE_TRANSACTION, (Object)data.originalCreateTransaction(), (arg_0, arg_1) -> TransactionBody.PROTOBUF.write(arg_0, arg_1), arg_0 -> TransactionBody.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)ScheduleSchema.SIGNATORIES, data.signatories(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Schedule data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.SCHEDULE_ID, (Object)data.scheduleId(), arg_0 -> ScheduleID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)ScheduleSchema.DELETED, (boolean)data.deleted());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)ScheduleSchema.EXECUTED, (boolean)data.executed());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)ScheduleSchema.WAIT_FOR_EXPIRY, (boolean)data.waitForExpiry());
        size += ProtoWriterTools.sizeOfString((FieldDefinition)ScheduleSchema.MEMO, (String)data.memo());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.SCHEDULER_ACCOUNT_ID, (Object)data.schedulerAccountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.PAYER_ACCOUNT_ID, (Object)data.payerAccountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.ADMIN_KEY, (Object)data.adminKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.SCHEDULE_VALID_START, (Object)data.scheduleValidStart(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ScheduleSchema.PROVIDED_EXPIRATION_SECOND, (long)data.providedExpirationSecond());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ScheduleSchema.CALCULATED_EXPIRATION_SECOND, (long)data.calculatedExpirationSecond());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.RESOLUTION_TIME, (Object)data.resolutionTime(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.SCHEDULED_TRANSACTION, (Object)data.scheduledTransaction(), arg_0 -> SchedulableTransactionBody.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ScheduleSchema.ORIGINAL_CREATE_TRANSACTION, (Object)data.originalCreateTransaction(), arg_0 -> TransactionBody.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ScheduleSchema.SIGNATORIES, data.signatories(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull Schedule item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private Schedule parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_schedule_id = null;
        boolean temp_deleted = false;
        boolean temp_executed = false;
        boolean temp_wait_for_expiry = false;
        String temp_memo = "";
        Record temp_scheduler_account_id = null;
        Record temp_payer_account_id = null;
        Record temp_admin_key = null;
        Record temp_schedule_valid_start = null;
        long temp_provided_expiration_second = 0L;
        long temp_calculated_expiration_second = 0L;
        Record temp_resolution_time = null;
        Record temp_scheduled_transaction = null;
        Record temp_original_create_transaction = null;
        List temp_signatories = Collections.emptyList();
        try {
            block19: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ScheduleSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ScheduleID)ScheduleID.PROTOBUF.parseStrict(input) : (ScheduleID)ScheduleID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_schedule_id = value;
                        continue block19;
                    }
                    case 16: {
                        boolean value;
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 24: {
                        boolean value;
                        temp_executed = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 32: {
                        boolean value;
                        temp_wait_for_expiry = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 42: {
                        String value;
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 50: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_scheduler_account_id = value;
                        continue block19;
                    }
                    case 58: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_payer_account_id = value;
                        continue block19;
                    }
                    case 66: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_admin_key = value;
                        continue block19;
                    }
                    case 74: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_schedule_valid_start = value;
                        continue block19;
                    }
                    case 80: {
                        long value;
                        temp_provided_expiration_second = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 88: {
                        long value;
                        temp_calculated_expiration_second = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 98: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_resolution_time = value;
                        continue block19;
                    }
                    case 106: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (SchedulableTransactionBody)SchedulableTransactionBody.PROTOBUF.parseStrict(input) : (SchedulableTransactionBody)SchedulableTransactionBody.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_scheduled_transaction = value;
                        continue block19;
                    }
                    case 114: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TransactionBody)TransactionBody.PROTOBUF.parseStrict(input) : (TransactionBody)TransactionBody.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_original_create_transaction = value;
                        continue block19;
                    }
                    case 122: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_signatories = ProtoParserTools.addToList(temp_signatories, (Object)value);
                        continue block19;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new Schedule((ScheduleID)temp_schedule_id, temp_deleted, temp_executed, temp_wait_for_expiry, temp_memo, (AccountID)temp_scheduler_account_id, (AccountID)temp_payer_account_id, (Key)temp_admin_key, (Timestamp)temp_schedule_valid_start, temp_provided_expiration_second, temp_calculated_expiration_second, (Timestamp)temp_resolution_time, (SchedulableTransactionBody)temp_scheduled_transaction, (TransactionBody)temp_original_create_transaction, temp_signatories);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new Schedule((ScheduleID)temp_schedule_id, temp_deleted, temp_executed, temp_wait_for_expiry, temp_memo, (AccountID)temp_scheduler_account_id, (AccountID)temp_payer_account_id, (Key)temp_admin_key, (Timestamp)temp_schedule_valid_start, temp_provided_expiration_second, temp_calculated_expiration_second, (Timestamp)temp_resolution_time, (SchedulableTransactionBody)temp_scheduled_transaction, (TransactionBody)temp_original_create_transaction, temp_signatories);
    }
}

