/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.throttles.codec;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshot;
import com.hedera.hapi.node.state.throttles.schema.ThrottleUsageSnapshotSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ThrottleUsageSnapshotProtoCodec
implements Codec<ThrottleUsageSnapshot> {
    @NonNull
    public ThrottleUsageSnapshot parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ThrottleUsageSnapshot parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ThrottleUsageSnapshot data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)ThrottleUsageSnapshotSchema.USED, (long)data.used());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ThrottleUsageSnapshotSchema.LAST_DECISION_TIME, (Object)data.lastDecisionTime(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ThrottleUsageSnapshot data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)ThrottleUsageSnapshotSchema.USED, (long)data.used());
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ThrottleUsageSnapshotSchema.LAST_DECISION_TIME, (Object)data.lastDecisionTime(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull ThrottleUsageSnapshot item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ThrottleUsageSnapshot parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        long temp_used = 0L;
        Timestamp temp_last_decision_time = null;
        try {
            block6: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ThrottleUsageSnapshotSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_used = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block6;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Timestamp value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_last_decision_time = value;
                        continue block6;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ThrottleUsageSnapshot(temp_used, temp_last_decision_time);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ThrottleUsageSnapshot(temp_used, temp_last_decision_time);
    }
}

