/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.token.codec.NftJsonCodec;
import com.hedera.hapi.node.state.token.codec.NftProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record Nft(@Nullable NftID nftId, @Nullable AccountID ownerId, @Nullable AccountID spenderId, @Nullable Timestamp mintTime, Bytes metadata, @Nullable NftID ownerPreviousNftId, @Nullable NftID ownerNextNftId) {
    public static final Codec<Nft> PROTOBUF = new NftProtoCodec();
    public static final JsonCodec<Nft> JSON = new NftJsonCodec();
    public static final Nft DEFAULT = Nft.newBuilder().build();

    public boolean hasNftId() {
        return this.nftId != null;
    }

    public NftID nftIdOrElse(@NonNull NftID defaultValue) {
        return this.hasNftId() ? this.nftId : defaultValue;
    }

    @NonNull
    public NftID nftIdOrThrow() {
        return Objects.requireNonNull(this.nftId, "Field nftId is null");
    }

    public void ifNftId(@NonNull Consumer<NftID> ifPresent) {
        if (this.hasNftId()) {
            ifPresent.accept(this.nftId);
        }
    }

    public boolean hasOwnerId() {
        return this.ownerId != null;
    }

    public AccountID ownerIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasOwnerId() ? this.ownerId : defaultValue;
    }

    @NonNull
    public AccountID ownerIdOrThrow() {
        return Objects.requireNonNull(this.ownerId, "Field ownerId is null");
    }

    public void ifOwnerId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasOwnerId()) {
            ifPresent.accept(this.ownerId);
        }
    }

    public boolean hasSpenderId() {
        return this.spenderId != null;
    }

    public AccountID spenderIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasSpenderId() ? this.spenderId : defaultValue;
    }

    @NonNull
    public AccountID spenderIdOrThrow() {
        return Objects.requireNonNull(this.spenderId, "Field spenderId is null");
    }

    public void ifSpenderId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSpenderId()) {
            ifPresent.accept(this.spenderId);
        }
    }

    public boolean hasMintTime() {
        return this.mintTime != null;
    }

    public Timestamp mintTimeOrElse(@NonNull Timestamp defaultValue) {
        return this.hasMintTime() ? this.mintTime : defaultValue;
    }

    @NonNull
    public Timestamp mintTimeOrThrow() {
        return Objects.requireNonNull(this.mintTime, "Field mintTime is null");
    }

    public void ifMintTime(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasMintTime()) {
            ifPresent.accept(this.mintTime);
        }
    }

    public boolean hasOwnerPreviousNftId() {
        return this.ownerPreviousNftId != null;
    }

    public NftID ownerPreviousNftIdOrElse(@NonNull NftID defaultValue) {
        return this.hasOwnerPreviousNftId() ? this.ownerPreviousNftId : defaultValue;
    }

    @NonNull
    public NftID ownerPreviousNftIdOrThrow() {
        return Objects.requireNonNull(this.ownerPreviousNftId, "Field ownerPreviousNftId is null");
    }

    public void ifOwnerPreviousNftId(@NonNull Consumer<NftID> ifPresent) {
        if (this.hasOwnerPreviousNftId()) {
            ifPresent.accept(this.ownerPreviousNftId);
        }
    }

    public boolean hasOwnerNextNftId() {
        return this.ownerNextNftId != null;
    }

    public NftID ownerNextNftIdOrElse(@NonNull NftID defaultValue) {
        return this.hasOwnerNextNftId() ? this.ownerNextNftId : defaultValue;
    }

    @NonNull
    public NftID ownerNextNftIdOrThrow() {
        return Objects.requireNonNull(this.ownerNextNftId, "Field ownerNextNftId is null");
    }

    public void ifOwnerNextNftId(@NonNull Consumer<NftID> ifPresent) {
        if (this.hasOwnerNextNftId()) {
            ifPresent.accept(this.ownerNextNftId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.nftId, this.ownerId, this.spenderId, this.mintTime, this.metadata, this.ownerPreviousNftId, this.ownerNextNftId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private NftID nftId = null;
        private AccountID ownerId = null;
        private AccountID spenderId = null;
        private Timestamp mintTime = null;
        private Bytes metadata = Bytes.EMPTY;
        private NftID ownerPreviousNftId = null;
        private NftID ownerNextNftId = null;

        public Builder() {
        }

        public Builder(NftID nftId, AccountID ownerId, AccountID spenderId, Timestamp mintTime, Bytes metadata, NftID ownerPreviousNftId, NftID ownerNextNftId) {
            this.nftId = nftId;
            this.ownerId = ownerId;
            this.spenderId = spenderId;
            this.mintTime = mintTime;
            this.metadata = metadata;
            this.ownerPreviousNftId = ownerPreviousNftId;
            this.ownerNextNftId = ownerNextNftId;
        }

        public Nft build() {
            return new Nft(this.nftId, this.ownerId, this.spenderId, this.mintTime, this.metadata, this.ownerPreviousNftId, this.ownerNextNftId);
        }

        public Builder nftId(NftID nftId) {
            this.nftId = nftId;
            return this;
        }

        public Builder nftId(NftID.Builder builder) {
            this.nftId = builder.build();
            return this;
        }

        public Builder ownerId(AccountID ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public Builder ownerId(AccountID.Builder builder) {
            this.ownerId = builder.build();
            return this;
        }

        public Builder spenderId(AccountID spenderId) {
            this.spenderId = spenderId;
            return this;
        }

        public Builder spenderId(AccountID.Builder builder) {
            this.spenderId = builder.build();
            return this;
        }

        public Builder mintTime(Timestamp mintTime) {
            this.mintTime = mintTime;
            return this;
        }

        public Builder mintTime(Timestamp.Builder builder) {
            this.mintTime = builder.build();
            return this;
        }

        public Builder metadata(Bytes metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder ownerPreviousNftId(NftID ownerPreviousNftId) {
            this.ownerPreviousNftId = ownerPreviousNftId;
            return this;
        }

        public Builder ownerPreviousNftId(NftID.Builder builder) {
            this.ownerPreviousNftId = builder.build();
            return this;
        }

        public Builder ownerNextNftId(NftID ownerNextNftId) {
            this.ownerNextNftId = ownerNextNftId;
            return this;
        }

        public Builder ownerNextNftId(NftID.Builder builder) {
            this.ownerNextNftId = builder.build();
            return this;
        }
    }
}

