/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.state.token.codec.TokenJsonCodec;
import com.hedera.hapi.node.state.token.codec.TokenProtoCodec;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record Token(@Nullable TokenID tokenId, String name, String symbol, int decimals, long totalSupply, @Nullable AccountID treasuryAccountId, @Nullable Key adminKey, @Nullable Key kycKey, @Nullable Key freezeKey, @Nullable Key wipeKey, @Nullable Key supplyKey, @Nullable Key feeScheduleKey, @Nullable Key pauseKey, long lastUsedSerialNumber, boolean deleted, TokenType tokenType, TokenSupplyType supplyType, @Nullable AccountID autoRenewAccountId, long autoRenewSeconds, long expirationSecond, String memo, long maxSupply, boolean paused, boolean accountsFrozenByDefault, boolean accountsKycGrantedByDefault, @Nullable List<CustomFee> customFees) {
    public static final Codec<Token> PROTOBUF = new TokenProtoCodec();
    public static final JsonCodec<Token> JSON = new TokenJsonCodec();
    public static final Token DEFAULT = Token.newBuilder().build();

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasTreasuryAccountId() {
        return this.treasuryAccountId != null;
    }

    public AccountID treasuryAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasTreasuryAccountId() ? this.treasuryAccountId : defaultValue;
    }

    @NonNull
    public AccountID treasuryAccountIdOrThrow() {
        return Objects.requireNonNull(this.treasuryAccountId, "Field treasuryAccountId is null");
    }

    public void ifTreasuryAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasTreasuryAccountId()) {
            ifPresent.accept(this.treasuryAccountId);
        }
    }

    public boolean hasAdminKey() {
        return this.adminKey != null;
    }

    public Key adminKeyOrElse(@NonNull Key defaultValue) {
        return this.hasAdminKey() ? this.adminKey : defaultValue;
    }

    @NonNull
    public Key adminKeyOrThrow() {
        return Objects.requireNonNull(this.adminKey, "Field adminKey is null");
    }

    public void ifAdminKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasAdminKey()) {
            ifPresent.accept(this.adminKey);
        }
    }

    public boolean hasKycKey() {
        return this.kycKey != null;
    }

    public Key kycKeyOrElse(@NonNull Key defaultValue) {
        return this.hasKycKey() ? this.kycKey : defaultValue;
    }

    @NonNull
    public Key kycKeyOrThrow() {
        return Objects.requireNonNull(this.kycKey, "Field kycKey is null");
    }

    public void ifKycKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasKycKey()) {
            ifPresent.accept(this.kycKey);
        }
    }

    public boolean hasFreezeKey() {
        return this.freezeKey != null;
    }

    public Key freezeKeyOrElse(@NonNull Key defaultValue) {
        return this.hasFreezeKey() ? this.freezeKey : defaultValue;
    }

    @NonNull
    public Key freezeKeyOrThrow() {
        return Objects.requireNonNull(this.freezeKey, "Field freezeKey is null");
    }

    public void ifFreezeKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasFreezeKey()) {
            ifPresent.accept(this.freezeKey);
        }
    }

    public boolean hasWipeKey() {
        return this.wipeKey != null;
    }

    public Key wipeKeyOrElse(@NonNull Key defaultValue) {
        return this.hasWipeKey() ? this.wipeKey : defaultValue;
    }

    @NonNull
    public Key wipeKeyOrThrow() {
        return Objects.requireNonNull(this.wipeKey, "Field wipeKey is null");
    }

    public void ifWipeKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasWipeKey()) {
            ifPresent.accept(this.wipeKey);
        }
    }

    public boolean hasSupplyKey() {
        return this.supplyKey != null;
    }

    public Key supplyKeyOrElse(@NonNull Key defaultValue) {
        return this.hasSupplyKey() ? this.supplyKey : defaultValue;
    }

    @NonNull
    public Key supplyKeyOrThrow() {
        return Objects.requireNonNull(this.supplyKey, "Field supplyKey is null");
    }

    public void ifSupplyKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasSupplyKey()) {
            ifPresent.accept(this.supplyKey);
        }
    }

    public boolean hasFeeScheduleKey() {
        return this.feeScheduleKey != null;
    }

    public Key feeScheduleKeyOrElse(@NonNull Key defaultValue) {
        return this.hasFeeScheduleKey() ? this.feeScheduleKey : defaultValue;
    }

    @NonNull
    public Key feeScheduleKeyOrThrow() {
        return Objects.requireNonNull(this.feeScheduleKey, "Field feeScheduleKey is null");
    }

    public void ifFeeScheduleKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasFeeScheduleKey()) {
            ifPresent.accept(this.feeScheduleKey);
        }
    }

    public boolean hasPauseKey() {
        return this.pauseKey != null;
    }

    public Key pauseKeyOrElse(@NonNull Key defaultValue) {
        return this.hasPauseKey() ? this.pauseKey : defaultValue;
    }

    @NonNull
    public Key pauseKeyOrThrow() {
        return Objects.requireNonNull(this.pauseKey, "Field pauseKey is null");
    }

    public void ifPauseKey(@NonNull Consumer<Key> ifPresent) {
        if (this.hasPauseKey()) {
            ifPresent.accept(this.pauseKey);
        }
    }

    public boolean hasAutoRenewAccountId() {
        return this.autoRenewAccountId != null;
    }

    public AccountID autoRenewAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAutoRenewAccountId() ? this.autoRenewAccountId : defaultValue;
    }

    @NonNull
    public AccountID autoRenewAccountIdOrThrow() {
        return Objects.requireNonNull(this.autoRenewAccountId, "Field autoRenewAccountId is null");
    }

    public void ifAutoRenewAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAutoRenewAccountId()) {
            ifPresent.accept(this.autoRenewAccountId);
        }
    }

    public boolean hasCustomFees() {
        return this.customFees != null;
    }

    public List<CustomFee> customFeesOrElse(@NonNull List<CustomFee> defaultValue) {
        return this.hasCustomFees() ? this.customFees : defaultValue;
    }

    @NonNull
    public List<CustomFee> customFeesOrThrow() {
        return Objects.requireNonNull(this.customFees, "Field customFees is null");
    }

    public void ifCustomFees(@NonNull Consumer<List<CustomFee>> ifPresent) {
        if (this.hasCustomFees()) {
            ifPresent.accept(this.customFees);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.name, this.symbol, this.decimals, this.totalSupply, this.treasuryAccountId, this.adminKey, this.kycKey, this.freezeKey, this.wipeKey, this.supplyKey, this.feeScheduleKey, this.pauseKey, this.lastUsedSerialNumber, this.deleted, this.tokenType, this.supplyType, this.autoRenewAccountId, this.autoRenewSeconds, this.expirationSecond, this.memo, this.maxSupply, this.paused, this.accountsFrozenByDefault, this.accountsKycGrantedByDefault, this.customFees);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID tokenId = null;
        private String name = "";
        private String symbol = "";
        private int decimals = 0;
        private long totalSupply = 0L;
        private AccountID treasuryAccountId = null;
        private Key adminKey = null;
        private Key kycKey = null;
        private Key freezeKey = null;
        private Key wipeKey = null;
        private Key supplyKey = null;
        private Key feeScheduleKey = null;
        private Key pauseKey = null;
        private long lastUsedSerialNumber = 0L;
        private boolean deleted = false;
        private TokenType tokenType = TokenType.values()[0];
        private TokenSupplyType supplyType = TokenSupplyType.values()[0];
        private AccountID autoRenewAccountId = null;
        private long autoRenewSeconds = 0L;
        private long expirationSecond = 0L;
        private String memo = "";
        private long maxSupply = 0L;
        private boolean paused = false;
        private boolean accountsFrozenByDefault = false;
        private boolean accountsKycGrantedByDefault = false;
        private List<CustomFee> customFees = Collections.emptyList();

        public Builder() {
        }

        public Builder(TokenID tokenId, String name, String symbol, int decimals, long totalSupply, AccountID treasuryAccountId, Key adminKey, Key kycKey, Key freezeKey, Key wipeKey, Key supplyKey, Key feeScheduleKey, Key pauseKey, long lastUsedSerialNumber, boolean deleted, TokenType tokenType, TokenSupplyType supplyType, AccountID autoRenewAccountId, long autoRenewSeconds, long expirationSecond, String memo, long maxSupply, boolean paused, boolean accountsFrozenByDefault, boolean accountsKycGrantedByDefault, List<CustomFee> customFees) {
            this.tokenId = tokenId;
            this.name = name;
            this.symbol = symbol;
            this.decimals = decimals;
            this.totalSupply = totalSupply;
            this.treasuryAccountId = treasuryAccountId;
            this.adminKey = adminKey;
            this.kycKey = kycKey;
            this.freezeKey = freezeKey;
            this.wipeKey = wipeKey;
            this.supplyKey = supplyKey;
            this.feeScheduleKey = feeScheduleKey;
            this.pauseKey = pauseKey;
            this.lastUsedSerialNumber = lastUsedSerialNumber;
            this.deleted = deleted;
            this.tokenType = tokenType;
            this.supplyType = supplyType;
            this.autoRenewAccountId = autoRenewAccountId;
            this.autoRenewSeconds = autoRenewSeconds;
            this.expirationSecond = expirationSecond;
            this.memo = memo;
            this.maxSupply = maxSupply;
            this.paused = paused;
            this.accountsFrozenByDefault = accountsFrozenByDefault;
            this.accountsKycGrantedByDefault = accountsKycGrantedByDefault;
            this.customFees = customFees;
        }

        public Token build() {
            return new Token(this.tokenId, this.name, this.symbol, this.decimals, this.totalSupply, this.treasuryAccountId, this.adminKey, this.kycKey, this.freezeKey, this.wipeKey, this.supplyKey, this.feeScheduleKey, this.pauseKey, this.lastUsedSerialNumber, this.deleted, this.tokenType, this.supplyType, this.autoRenewAccountId, this.autoRenewSeconds, this.expirationSecond, this.memo, this.maxSupply, this.paused, this.accountsFrozenByDefault, this.accountsKycGrantedByDefault, this.customFees);
        }

        public Builder tokenId(TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder symbol(String symbol) {
            this.symbol = symbol;
            return this;
        }

        public Builder decimals(int decimals) {
            this.decimals = decimals;
            return this;
        }

        public Builder totalSupply(long totalSupply) {
            this.totalSupply = totalSupply;
            return this;
        }

        public Builder treasuryAccountId(AccountID treasuryAccountId) {
            this.treasuryAccountId = treasuryAccountId;
            return this;
        }

        public Builder treasuryAccountId(AccountID.Builder builder) {
            this.treasuryAccountId = builder.build();
            return this;
        }

        public Builder adminKey(Key adminKey) {
            this.adminKey = adminKey;
            return this;
        }

        public Builder adminKey(Key.Builder builder) {
            this.adminKey = builder.build();
            return this;
        }

        public Builder kycKey(Key kycKey) {
            this.kycKey = kycKey;
            return this;
        }

        public Builder kycKey(Key.Builder builder) {
            this.kycKey = builder.build();
            return this;
        }

        public Builder freezeKey(Key freezeKey) {
            this.freezeKey = freezeKey;
            return this;
        }

        public Builder freezeKey(Key.Builder builder) {
            this.freezeKey = builder.build();
            return this;
        }

        public Builder wipeKey(Key wipeKey) {
            this.wipeKey = wipeKey;
            return this;
        }

        public Builder wipeKey(Key.Builder builder) {
            this.wipeKey = builder.build();
            return this;
        }

        public Builder supplyKey(Key supplyKey) {
            this.supplyKey = supplyKey;
            return this;
        }

        public Builder supplyKey(Key.Builder builder) {
            this.supplyKey = builder.build();
            return this;
        }

        public Builder feeScheduleKey(Key feeScheduleKey) {
            this.feeScheduleKey = feeScheduleKey;
            return this;
        }

        public Builder feeScheduleKey(Key.Builder builder) {
            this.feeScheduleKey = builder.build();
            return this;
        }

        public Builder pauseKey(Key pauseKey) {
            this.pauseKey = pauseKey;
            return this;
        }

        public Builder pauseKey(Key.Builder builder) {
            this.pauseKey = builder.build();
            return this;
        }

        public Builder lastUsedSerialNumber(long lastUsedSerialNumber) {
            this.lastUsedSerialNumber = lastUsedSerialNumber;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder tokenType(TokenType tokenType) {
            this.tokenType = tokenType;
            return this;
        }

        public Builder supplyType(TokenSupplyType supplyType) {
            this.supplyType = supplyType;
            return this;
        }

        public Builder autoRenewAccountId(AccountID autoRenewAccountId) {
            this.autoRenewAccountId = autoRenewAccountId;
            return this;
        }

        public Builder autoRenewAccountId(AccountID.Builder builder) {
            this.autoRenewAccountId = builder.build();
            return this;
        }

        public Builder autoRenewSeconds(long autoRenewSeconds) {
            this.autoRenewSeconds = autoRenewSeconds;
            return this;
        }

        public Builder expirationSecond(long expirationSecond) {
            this.expirationSecond = expirationSecond;
            return this;
        }

        public Builder memo(String memo) {
            this.memo = memo;
            return this;
        }

        public Builder maxSupply(long maxSupply) {
            this.maxSupply = maxSupply;
            return this;
        }

        public Builder paused(boolean paused) {
            this.paused = paused;
            return this;
        }

        public Builder accountsFrozenByDefault(boolean accountsFrozenByDefault) {
            this.accountsFrozenByDefault = accountsFrozenByDefault;
            return this;
        }

        public Builder accountsKycGrantedByDefault(boolean accountsKycGrantedByDefault) {
            this.accountsKycGrantedByDefault = accountsKycGrantedByDefault;
            return this;
        }

        public Builder customFees(List<CustomFee> customFees) {
            this.customFees = customFees;
            return this;
        }

        public Builder customFees(CustomFee ... values) {
            this.customFees = List.of(values);
            return this;
        }
    }
}

