/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.codec.TokenRelationJsonCodec;
import com.hedera.hapi.node.state.token.codec.TokenRelationProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenRelation(@Nullable TokenID tokenId, @Nullable AccountID accountId, long balance, boolean frozen, boolean kycGranted, boolean deleted, boolean automaticAssociation, @Nullable TokenID previousToken, @Nullable TokenID nextToken) {
    public static final Codec<TokenRelation> PROTOBUF = new TokenRelationProtoCodec();
    public static final JsonCodec<TokenRelation> JSON = new TokenRelationJsonCodec();
    public static final TokenRelation DEFAULT = TokenRelation.newBuilder().build();

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasAccountId() {
        return this.accountId != null;
    }

    public AccountID accountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountId() ? this.accountId : defaultValue;
    }

    @NonNull
    public AccountID accountIdOrThrow() {
        return Objects.requireNonNull(this.accountId, "Field accountId is null");
    }

    public void ifAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountId()) {
            ifPresent.accept(this.accountId);
        }
    }

    public boolean hasPreviousToken() {
        return this.previousToken != null;
    }

    public TokenID previousTokenOrElse(@NonNull TokenID defaultValue) {
        return this.hasPreviousToken() ? this.previousToken : defaultValue;
    }

    @NonNull
    public TokenID previousTokenOrThrow() {
        return Objects.requireNonNull(this.previousToken, "Field previousToken is null");
    }

    public void ifPreviousToken(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasPreviousToken()) {
            ifPresent.accept(this.previousToken);
        }
    }

    public boolean hasNextToken() {
        return this.nextToken != null;
    }

    public TokenID nextTokenOrElse(@NonNull TokenID defaultValue) {
        return this.hasNextToken() ? this.nextToken : defaultValue;
    }

    @NonNull
    public TokenID nextTokenOrThrow() {
        return Objects.requireNonNull(this.nextToken, "Field nextToken is null");
    }

    public void ifNextToken(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasNextToken()) {
            ifPresent.accept(this.nextToken);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.accountId, this.balance, this.frozen, this.kycGranted, this.deleted, this.automaticAssociation, this.previousToken, this.nextToken);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID tokenId = null;
        private AccountID accountId = null;
        private long balance = 0L;
        private boolean frozen = false;
        private boolean kycGranted = false;
        private boolean deleted = false;
        private boolean automaticAssociation = false;
        private TokenID previousToken = null;
        private TokenID nextToken = null;

        public Builder() {
        }

        public Builder(TokenID tokenId, AccountID accountId, long balance, boolean frozen, boolean kycGranted, boolean deleted, boolean automaticAssociation, TokenID previousToken, TokenID nextToken) {
            this.tokenId = tokenId;
            this.accountId = accountId;
            this.balance = balance;
            this.frozen = frozen;
            this.kycGranted = kycGranted;
            this.deleted = deleted;
            this.automaticAssociation = automaticAssociation;
            this.previousToken = previousToken;
            this.nextToken = nextToken;
        }

        public TokenRelation build() {
            return new TokenRelation(this.tokenId, this.accountId, this.balance, this.frozen, this.kycGranted, this.deleted, this.automaticAssociation, this.previousToken, this.nextToken);
        }

        public Builder tokenId(TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder accountId(AccountID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountId(AccountID.Builder builder) {
            this.accountId = builder.build();
            return this;
        }

        public Builder balance(long balance) {
            this.balance = balance;
            return this;
        }

        public Builder frozen(boolean frozen) {
            this.frozen = frozen;
            return this;
        }

        public Builder kycGranted(boolean kycGranted) {
            this.kycGranted = kycGranted;
            return this;
        }

        public Builder deleted(boolean deleted) {
            this.deleted = deleted;
            return this;
        }

        public Builder automaticAssociation(boolean automaticAssociation) {
            this.automaticAssociation = automaticAssociation;
            return this;
        }

        public Builder previousToken(TokenID previousToken) {
            this.previousToken = previousToken;
            return this;
        }

        public Builder previousToken(TokenID.Builder builder) {
            this.previousToken = builder.build();
            return this;
        }

        public Builder nextToken(TokenID nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public Builder nextToken(TokenID.Builder builder) {
            this.nextToken = builder.build();
            return this;
        }
    }
}

