/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token.codec;

import com.hedera.hapi.node.state.token.NetworkStakingRewards;
import com.hedera.hapi.node.state.token.schema.NetworkStakingRewardsSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class NetworkStakingRewardsProtoCodec
implements Codec<NetworkStakingRewards> {
    @NonNull
    public NetworkStakingRewards parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public NetworkStakingRewards parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull NetworkStakingRewards data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)NetworkStakingRewardsSchema.STAKING_REWARDS_ACTIVATED, (boolean)data.stakingRewardsActivated());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NetworkStakingRewardsSchema.TOTAL_STAKED_REWARD_START, (long)data.totalStakedRewardStart());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NetworkStakingRewardsSchema.TOTAL_STAKED_START, (long)data.totalStakedStart());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NetworkStakingRewardsSchema.PENDING_REWARDS, (long)data.pendingRewards());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(NetworkStakingRewards data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)NetworkStakingRewardsSchema.STAKING_REWARDS_ACTIVATED, (boolean)data.stakingRewardsActivated());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NetworkStakingRewardsSchema.TOTAL_STAKED_REWARD_START, (long)data.totalStakedRewardStart());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NetworkStakingRewardsSchema.TOTAL_STAKED_START, (long)data.totalStakedStart());
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)NetworkStakingRewardsSchema.PENDING_REWARDS, (long)data.pendingRewards());
    }

    public boolean fastEquals(@NonNull NetworkStakingRewards item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private NetworkStakingRewards parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        boolean temp_staking_rewards_activated = false;
        long temp_total_staked_reward_start = 0L;
        long temp_total_staked_start = 0L;
        long temp_pending_rewards = 0L;
        try {
            block8: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = NetworkStakingRewardsSchema.getField(field);
                switch (tag) {
                    case 8: {
                        boolean value;
                        temp_staking_rewards_activated = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 16: {
                        long value;
                        temp_total_staked_reward_start = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 24: {
                        long value;
                        temp_total_staked_start = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 32: {
                        long value;
                        temp_pending_rewards = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block8;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new NetworkStakingRewards(temp_staking_rewards_activated, temp_total_staked_reward_start, temp_total_staked_start, temp_pending_rewards);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new NetworkStakingRewards(temp_staking_rewards_activated, temp_total_staked_reward_start, temp_total_staked_start, temp_pending_rewards);
    }
}

