/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.state.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.schema.NftSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class NftProtoCodec
implements Codec<Nft> {
    @NonNull
    public Nft parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public Nft parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull Nft data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NftSchema.NFT_ID, (Object)data.nftId(), (arg_0, arg_1) -> NftID.PROTOBUF.write(arg_0, arg_1), arg_0 -> NftID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NftSchema.OWNER_ID, (Object)data.ownerId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NftSchema.SPENDER_ID, (Object)data.spenderId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NftSchema.MINT_TIME, (Object)data.mintTime(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)NftSchema.METADATA, (RandomAccessData)data.metadata());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NftSchema.OWNER_PREVIOUS_NFT_ID, (Object)data.ownerPreviousNftId(), (arg_0, arg_1) -> NftID.PROTOBUF.write(arg_0, arg_1), arg_0 -> NftID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NftSchema.OWNER_NEXT_NFT_ID, (Object)data.ownerNextNftId(), (arg_0, arg_1) -> NftID.PROTOBUF.write(arg_0, arg_1), arg_0 -> NftID.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(Nft data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftSchema.NFT_ID, (Object)data.nftId(), arg_0 -> NftID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftSchema.OWNER_ID, (Object)data.ownerId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftSchema.SPENDER_ID, (Object)data.spenderId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftSchema.MINT_TIME, (Object)data.mintTime(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)NftSchema.METADATA, (RandomAccessData)data.metadata());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftSchema.OWNER_PREVIOUS_NFT_ID, (Object)data.ownerPreviousNftId(), arg_0 -> NftID.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftSchema.OWNER_NEXT_NFT_ID, (Object)data.ownerNextNftId(), arg_0 -> NftID.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull Nft item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private Nft parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_nft_id = null;
        Record temp_owner_id = null;
        Record temp_spender_id = null;
        Record temp_mint_time = null;
        Bytes temp_metadata = Bytes.EMPTY;
        Record temp_owner_previous_nft_id = null;
        Record temp_owner_next_nft_id = null;
        try {
            block11: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = NftSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (NftID)NftID.PROTOBUF.parseStrict(input) : (NftID)NftID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_nft_id = value;
                        continue block11;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_owner_id = value;
                        continue block11;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_spender_id = value;
                        continue block11;
                    }
                    case 34: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_mint_time = value;
                        continue block11;
                    }
                    case 42: {
                        Bytes value;
                        temp_metadata = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block11;
                    }
                    case 50: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (NftID)NftID.PROTOBUF.parseStrict(input) : (NftID)NftID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_owner_previous_nft_id = value;
                        continue block11;
                    }
                    case 58: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (NftID)NftID.PROTOBUF.parseStrict(input) : (NftID)NftID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_owner_next_nft_id = value;
                        continue block11;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new Nft((NftID)temp_nft_id, (AccountID)temp_owner_id, (AccountID)temp_spender_id, (Timestamp)temp_mint_time, temp_metadata, (NftID)temp_owner_previous_nft_id, (NftID)temp_owner_next_nft_id);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new Nft((NftID)temp_nft_id, (AccountID)temp_owner_id, (AccountID)temp_spender_id, (Timestamp)temp_mint_time, temp_metadata, (NftID)temp_owner_previous_nft_id, (NftID)temp_owner_next_nft_id);
    }
}

