/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.token.codec.LiveHashJsonCodec;
import com.hedera.hapi.node.token.codec.LiveHashProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record LiveHash(@Nullable AccountID accountId, Bytes hash, @Nullable KeyList keys, @Nullable Duration duration) {
    public static final Codec<LiveHash> PROTOBUF = new LiveHashProtoCodec();
    public static final JsonCodec<LiveHash> JSON = new LiveHashJsonCodec();
    public static final LiveHash DEFAULT = LiveHash.newBuilder().build();

    public boolean hasAccountId() {
        return this.accountId != null;
    }

    public AccountID accountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountId() ? this.accountId : defaultValue;
    }

    @NonNull
    public AccountID accountIdOrThrow() {
        return Objects.requireNonNull(this.accountId, "Field accountId is null");
    }

    public void ifAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountId()) {
            ifPresent.accept(this.accountId);
        }
    }

    public boolean hasKeys() {
        return this.keys != null;
    }

    public KeyList keysOrElse(@NonNull KeyList defaultValue) {
        return this.hasKeys() ? this.keys : defaultValue;
    }

    @NonNull
    public KeyList keysOrThrow() {
        return Objects.requireNonNull(this.keys, "Field keys is null");
    }

    public void ifKeys(@NonNull Consumer<KeyList> ifPresent) {
        if (this.hasKeys()) {
            ifPresent.accept(this.keys);
        }
    }

    public boolean hasDuration() {
        return this.duration != null;
    }

    public Duration durationOrElse(@NonNull Duration defaultValue) {
        return this.hasDuration() ? this.duration : defaultValue;
    }

    @NonNull
    public Duration durationOrThrow() {
        return Objects.requireNonNull(this.duration, "Field duration is null");
    }

    public void ifDuration(@NonNull Consumer<Duration> ifPresent) {
        if (this.hasDuration()) {
            ifPresent.accept(this.duration);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.accountId, this.hash, this.keys, this.duration);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private AccountID accountId = null;
        private Bytes hash = Bytes.EMPTY;
        private KeyList keys = null;
        private Duration duration = null;

        public Builder() {
        }

        public Builder(AccountID accountId, Bytes hash, KeyList keys, Duration duration) {
            this.accountId = accountId;
            this.hash = hash;
            this.keys = keys;
            this.duration = duration;
        }

        public LiveHash build() {
            return new LiveHash(this.accountId, this.hash, this.keys, this.duration);
        }

        public Builder accountId(AccountID accountId) {
            this.accountId = accountId;
            return this;
        }

        public Builder accountId(AccountID.Builder builder) {
            this.accountId = builder.build();
            return this;
        }

        public Builder hash(Bytes hash) {
            this.hash = hash;
            return this;
        }

        public Builder keys(KeyList keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(KeyList.Builder builder) {
            this.keys = builder.build();
            return this;
        }

        public Builder duration(Duration duration) {
            this.duration = duration;
            return this;
        }

        public Builder duration(Duration.Builder builder) {
            this.duration = builder.build();
            return this;
        }
    }
}

