/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.codec.TokenBurnTransactionBodyJsonCodec;
import com.hedera.hapi.node.token.codec.TokenBurnTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenBurnTransactionBody(@Nullable TokenID token, long amount, List<Long> serialNumbers) {
    public static final Codec<TokenBurnTransactionBody> PROTOBUF = new TokenBurnTransactionBodyProtoCodec();
    public static final JsonCodec<TokenBurnTransactionBody> JSON = new TokenBurnTransactionBodyJsonCodec();
    public static final TokenBurnTransactionBody DEFAULT = TokenBurnTransactionBody.newBuilder().build();

    public boolean hasToken() {
        return this.token != null;
    }

    public TokenID tokenOrElse(@NonNull TokenID defaultValue) {
        return this.hasToken() ? this.token : defaultValue;
    }

    @NonNull
    public TokenID tokenOrThrow() {
        return Objects.requireNonNull(this.token, "Field token is null");
    }

    public void ifToken(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasToken()) {
            ifPresent.accept(this.token);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.token, this.amount, this.serialNumbers);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID token = null;
        private long amount = 0L;
        private List<Long> serialNumbers = Collections.emptyList();

        public Builder() {
        }

        public Builder(TokenID token, long amount, List<Long> serialNumbers) {
            this.token = token;
            this.amount = amount;
            this.serialNumbers = serialNumbers;
        }

        public TokenBurnTransactionBody build() {
            return new TokenBurnTransactionBody(this.token, this.amount, this.serialNumbers);
        }

        public Builder token(TokenID token) {
            this.token = token;
            return this;
        }

        public Builder token(TokenID.Builder builder) {
            this.token = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder serialNumbers(List<Long> serialNumbers) {
            this.serialNumbers = serialNumbers;
            return this;
        }

        public Builder serialNumbers(Long ... values) {
            this.serialNumbers = List.of(values);
            return this;
        }
    }
}

