/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.codec.TokenMintTransactionBodyJsonCodec;
import com.hedera.hapi.node.token.codec.TokenMintTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenMintTransactionBody(@Nullable TokenID token, long amount, List<Bytes> metadata) {
    public static final Codec<TokenMintTransactionBody> PROTOBUF = new TokenMintTransactionBodyProtoCodec();
    public static final JsonCodec<TokenMintTransactionBody> JSON = new TokenMintTransactionBodyJsonCodec();
    public static final TokenMintTransactionBody DEFAULT = TokenMintTransactionBody.newBuilder().build();

    public boolean hasToken() {
        return this.token != null;
    }

    public TokenID tokenOrElse(@NonNull TokenID defaultValue) {
        return this.hasToken() ? this.token : defaultValue;
    }

    @NonNull
    public TokenID tokenOrThrow() {
        return Objects.requireNonNull(this.token, "Field token is null");
    }

    public void ifToken(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasToken()) {
            ifPresent.accept(this.token);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.token, this.amount, this.metadata);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID token = null;
        private long amount = 0L;
        private List<Bytes> metadata = Collections.emptyList();

        public Builder() {
        }

        public Builder(TokenID token, long amount, List<Bytes> metadata) {
            this.token = token;
            this.amount = amount;
            this.metadata = metadata;
        }

        public TokenMintTransactionBody build() {
            return new TokenMintTransactionBody(this.token, this.amount, this.metadata);
        }

        public Builder token(TokenID token) {
            this.token = token;
            return this;
        }

        public Builder token(TokenID.Builder builder) {
            this.token = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder metadata(List<Bytes> metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder metadata(Bytes ... values) {
            this.metadata = List.of(values);
            return this;
        }
    }
}

