/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.token.codec.TokenWipeAccountTransactionBodyJsonCodec;
import com.hedera.hapi.node.token.codec.TokenWipeAccountTransactionBodyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenWipeAccountTransactionBody(@Nullable TokenID token, @Nullable AccountID account, long amount, List<Long> serialNumbers) {
    public static final Codec<TokenWipeAccountTransactionBody> PROTOBUF = new TokenWipeAccountTransactionBodyProtoCodec();
    public static final JsonCodec<TokenWipeAccountTransactionBody> JSON = new TokenWipeAccountTransactionBodyJsonCodec();
    public static final TokenWipeAccountTransactionBody DEFAULT = TokenWipeAccountTransactionBody.newBuilder().build();

    public boolean hasToken() {
        return this.token != null;
    }

    public TokenID tokenOrElse(@NonNull TokenID defaultValue) {
        return this.hasToken() ? this.token : defaultValue;
    }

    @NonNull
    public TokenID tokenOrThrow() {
        return Objects.requireNonNull(this.token, "Field token is null");
    }

    public void ifToken(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasToken()) {
            ifPresent.accept(this.token);
        }
    }

    public boolean hasAccount() {
        return this.account != null;
    }

    public AccountID accountOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccount() ? this.account : defaultValue;
    }

    @NonNull
    public AccountID accountOrThrow() {
        return Objects.requireNonNull(this.account, "Field account is null");
    }

    public void ifAccount(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccount()) {
            ifPresent.accept(this.account);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.token, this.account, this.amount, this.serialNumbers);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID token = null;
        private AccountID account = null;
        private long amount = 0L;
        private List<Long> serialNumbers = Collections.emptyList();

        public Builder() {
        }

        public Builder(TokenID token, AccountID account, long amount, List<Long> serialNumbers) {
            this.token = token;
            this.account = account;
            this.amount = amount;
            this.serialNumbers = serialNumbers;
        }

        public TokenWipeAccountTransactionBody build() {
            return new TokenWipeAccountTransactionBody(this.token, this.account, this.amount, this.serialNumbers);
        }

        public Builder token(TokenID token) {
            this.token = token;
            return this;
        }

        public Builder token(TokenID.Builder builder) {
            this.token = builder.build();
            return this;
        }

        public Builder account(AccountID account) {
            this.account = account;
            return this;
        }

        public Builder account(AccountID.Builder builder) {
            this.account = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder serialNumbers(List<Long> serialNumbers) {
            this.serialNumbers = serialNumbers;
            return this;
        }

        public Builder serialNumbers(Long ... values) {
            this.serialNumbers = List.of(values);
            return this;
        }
    }
}

