/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.StakingInfo;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenRelationship;
import com.hedera.hapi.node.token.AccountInfo;
import com.hedera.hapi.node.token.LiveHash;
import com.hedera.hapi.node.token.schema.AccountInfoSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class AccountInfoProtoCodec
implements Codec<AccountInfo> {
    @NonNull
    public AccountInfo parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public AccountInfo parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull AccountInfo data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.ACCOUNT_ID, (Object)data.accountID(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.CONTRACT_ACCOUNT_ID, (String)data.contractAccountID());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.DELETED, (boolean)data.deleted());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.PROXY_ACCOUNT_ID, (Object)data.proxyAccountID(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.PROXY_RECEIVED, (long)data.proxyReceived());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.KEY, (Object)data.key(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.BALANCE, (long)data.balance());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.GENERATE_SEND_RECORD_THRESHOLD, (long)data.generateSendRecordThreshold());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.GENERATE_RECEIVE_RECORD_THRESHOLD, (long)data.generateReceiveRecordThreshold());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.RECEIVER_SIG_REQUIRED, (boolean)data.receiverSigRequired());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.EXPIRATION_TIME, (Object)data.expirationTime(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.AUTO_RENEW_PERIOD, (Object)data.autoRenewPeriod(), (arg_0, arg_1) -> Duration.PROTOBUF.write(arg_0, arg_1), arg_0 -> Duration.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.LIVE_HASHES, data.liveHashes(), (arg_0, arg_1) -> LiveHash.PROTOBUF.write(arg_0, arg_1), arg_0 -> LiveHash.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.TOKEN_RELATIONSHIPS, data.tokenRelationships(), (arg_0, arg_1) -> TokenRelationship.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenRelationship.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.OWNED_NFTS, (long)data.ownedNfts());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.MAX_AUTOMATIC_TOKEN_ASSOCIATIONS, (int)data.maxAutomaticTokenAssociations());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.ALIAS, (RandomAccessData)data.alias());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.LEDGER_ID, (RandomAccessData)data.ledgerId());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.ETHEREUM_NONCE, (long)data.ethereumNonce());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)AccountInfoSchema.STAKING_INFO, (Object)data.stakingInfo(), (arg_0, arg_1) -> StakingInfo.PROTOBUF.write(arg_0, arg_1), arg_0 -> StakingInfo.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(AccountInfo data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountInfoSchema.ACCOUNT_ID, (Object)data.accountID(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfString((FieldDefinition)AccountInfoSchema.CONTRACT_ACCOUNT_ID, (String)data.contractAccountID());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)AccountInfoSchema.DELETED, (boolean)data.deleted());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountInfoSchema.PROXY_ACCOUNT_ID, (Object)data.proxyAccountID(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountInfoSchema.PROXY_RECEIVED, (long)data.proxyReceived());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountInfoSchema.KEY, (Object)data.key(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountInfoSchema.BALANCE, (long)data.balance());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountInfoSchema.GENERATE_SEND_RECORD_THRESHOLD, (long)data.generateSendRecordThreshold());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountInfoSchema.GENERATE_RECEIVE_RECORD_THRESHOLD, (long)data.generateReceiveRecordThreshold());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)AccountInfoSchema.RECEIVER_SIG_REQUIRED, (boolean)data.receiverSigRequired());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountInfoSchema.EXPIRATION_TIME, (Object)data.expirationTime(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountInfoSchema.AUTO_RENEW_PERIOD, (Object)data.autoRenewPeriod(), arg_0 -> Duration.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)AccountInfoSchema.LIVE_HASHES, data.liveHashes(), arg_0 -> LiveHash.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)AccountInfoSchema.TOKEN_RELATIONSHIPS, data.tokenRelationships(), arg_0 -> TokenRelationship.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfString((FieldDefinition)AccountInfoSchema.MEMO, (String)data.memo());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountInfoSchema.OWNED_NFTS, (long)data.ownedNfts());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)AccountInfoSchema.MAX_AUTOMATIC_TOKEN_ASSOCIATIONS, (int)data.maxAutomaticTokenAssociations());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)AccountInfoSchema.ALIAS, (RandomAccessData)data.alias());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)AccountInfoSchema.LEDGER_ID, (RandomAccessData)data.ledgerId());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)AccountInfoSchema.ETHEREUM_NONCE, (long)data.ethereumNonce());
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)AccountInfoSchema.STAKING_INFO, (Object)data.stakingInfo(), arg_0 -> StakingInfo.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull AccountInfo item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private AccountInfo parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_accountID = null;
        String temp_contractAccountID = "";
        boolean temp_deleted = false;
        Record temp_proxyAccountID = null;
        long temp_proxyReceived = 0L;
        Record temp_key = null;
        long temp_balance = 0L;
        long temp_generateSendRecordThreshold = 0L;
        long temp_generateReceiveRecordThreshold = 0L;
        boolean temp_receiverSigRequired = false;
        Record temp_expirationTime = null;
        Record temp_autoRenewPeriod = null;
        List temp_liveHashes = Collections.emptyList();
        List temp_tokenRelationships = Collections.emptyList();
        String temp_memo = "";
        long temp_ownedNfts = 0L;
        int temp_max_automatic_token_associations = 0;
        Bytes temp_alias = Bytes.EMPTY;
        Bytes temp_ledger_id = Bytes.EMPTY;
        long temp_ethereum_nonce = 0L;
        Record temp_staking_info = null;
        try {
            block25: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = AccountInfoSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_accountID = value;
                        continue block25;
                    }
                    case 18: {
                        String value;
                        temp_contractAccountID = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block25;
                    }
                    case 24: {
                        boolean value;
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block25;
                    }
                    case 34: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_proxyAccountID = value;
                        continue block25;
                    }
                    case 48: {
                        long value;
                        temp_proxyReceived = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block25;
                    }
                    case 58: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_key = value;
                        continue block25;
                    }
                    case 64: {
                        long value;
                        temp_balance = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block25;
                    }
                    case 72: {
                        long value;
                        temp_generateSendRecordThreshold = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block25;
                    }
                    case 80: {
                        long value;
                        temp_generateReceiveRecordThreshold = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block25;
                    }
                    case 88: {
                        boolean value;
                        temp_receiverSigRequired = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block25;
                    }
                    case 98: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_expirationTime = value;
                        continue block25;
                    }
                    case 106: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Duration)Duration.PROTOBUF.parseStrict(input) : (Duration)Duration.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_autoRenewPeriod = value;
                        continue block25;
                    }
                    case 114: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (LiveHash)LiveHash.PROTOBUF.parseStrict(input) : (LiveHash)LiveHash.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_liveHashes = ProtoParserTools.addToList(temp_liveHashes, (Object)value);
                        continue block25;
                    }
                    case 122: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TokenRelationship)TokenRelationship.PROTOBUF.parseStrict(input) : (TokenRelationship)TokenRelationship.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_tokenRelationships = ProtoParserTools.addToList(temp_tokenRelationships, (Object)value);
                        continue block25;
                    }
                    case 130: {
                        String value;
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block25;
                    }
                    case 136: {
                        long value;
                        temp_ownedNfts = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block25;
                    }
                    case 144: {
                        int value;
                        temp_max_automatic_token_associations = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block25;
                    }
                    case 154: {
                        Bytes value;
                        temp_alias = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block25;
                    }
                    case 162: {
                        Bytes value;
                        temp_ledger_id = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block25;
                    }
                    case 168: {
                        long value;
                        temp_ethereum_nonce = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block25;
                    }
                    case 178: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (StakingInfo)StakingInfo.PROTOBUF.parseStrict(input) : (StakingInfo)StakingInfo.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_staking_info = value;
                        continue block25;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new AccountInfo((AccountID)temp_accountID, temp_contractAccountID, temp_deleted, (AccountID)temp_proxyAccountID, temp_proxyReceived, (Key)temp_key, temp_balance, temp_generateSendRecordThreshold, temp_generateReceiveRecordThreshold, temp_receiverSigRequired, (Timestamp)temp_expirationTime, (Duration)temp_autoRenewPeriod, temp_liveHashes, temp_tokenRelationships, temp_memo, temp_ownedNfts, temp_max_automatic_token_associations, temp_alias, temp_ledger_id, temp_ethereum_nonce, (StakingInfo)temp_staking_info);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new AccountInfo((AccountID)temp_accountID, temp_contractAccountID, temp_deleted, (AccountID)temp_proxyAccountID, temp_proxyReceived, (Key)temp_key, temp_balance, temp_generateSendRecordThreshold, temp_generateReceiveRecordThreshold, temp_receiverSigRequired, (Timestamp)temp_expirationTime, (Duration)temp_autoRenewPeriod, temp_liveHashes, temp_tokenRelationships, temp_memo, temp_ownedNfts, temp_max_automatic_token_associations, temp_alias, temp_ledger_id, temp_ethereum_nonce, (StakingInfo)temp_staking_info);
    }
}

