/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.token.LiveHash;
import com.hedera.hapi.node.token.schema.LiveHashSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class LiveHashProtoCodec
implements Codec<LiveHash> {
    @NonNull
    public LiveHash parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public LiveHash parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull LiveHash data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)LiveHashSchema.ACCOUNT_ID, (Object)data.accountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)LiveHashSchema.HASH, (RandomAccessData)data.hash());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)LiveHashSchema.KEYS, (Object)data.keys(), (arg_0, arg_1) -> KeyList.PROTOBUF.write(arg_0, arg_1), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)LiveHashSchema.DURATION, (Object)data.duration(), (arg_0, arg_1) -> Duration.PROTOBUF.write(arg_0, arg_1), arg_0 -> Duration.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(LiveHash data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)LiveHashSchema.ACCOUNT_ID, (Object)data.accountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)LiveHashSchema.HASH, (RandomAccessData)data.hash());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)LiveHashSchema.KEYS, (Object)data.keys(), arg_0 -> KeyList.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)LiveHashSchema.DURATION, (Object)data.duration(), arg_0 -> Duration.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull LiveHash item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private LiveHash parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_accountId = null;
        Bytes temp_hash = Bytes.EMPTY;
        Record temp_keys = null;
        Record temp_duration = null;
        try {
            block8: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = LiveHashSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_accountId = value;
                        continue block8;
                    }
                    case 18: {
                        Bytes value;
                        temp_hash = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (KeyList)KeyList.PROTOBUF.parseStrict(input) : (KeyList)KeyList.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_keys = value;
                        continue block8;
                    }
                    case 42: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Duration)Duration.PROTOBUF.parseStrict(input) : (Duration)Duration.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_duration = value;
                        continue block8;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new LiveHash((AccountID)temp_accountId, temp_hash, (KeyList)temp_keys, (Duration)temp_duration);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new LiveHash((AccountID)temp_accountId, temp_hash, (KeyList)temp_keys, (Duration)temp_duration);
    }
}

