/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenFreezeStatus;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenKycStatus;
import com.hedera.hapi.node.base.TokenPauseStatus;
import com.hedera.hapi.node.base.TokenSupplyType;
import com.hedera.hapi.node.base.TokenType;
import com.hedera.hapi.node.token.TokenInfo;
import com.hedera.hapi.node.token.schema.TokenInfoSchema;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class TokenInfoProtoCodec
implements Codec<TokenInfo> {
    @NonNull
    public TokenInfo parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public TokenInfo parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull TokenInfo data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.TOKEN_ID, (Object)data.tokenId(), (arg_0, arg_1) -> TokenID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.NAME, (String)data.name());
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.SYMBOL, (String)data.symbol());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.DECIMALS, (int)data.decimals());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.TOTAL_SUPPLY, (long)data.totalSupply());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.TREASURY, (Object)data.treasury(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.ADMIN_KEY, (Object)data.adminKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.KYC_KEY, (Object)data.kycKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.FREEZE_KEY, (Object)data.freezeKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.WIPE_KEY, (Object)data.wipeKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.SUPPLY_KEY, (Object)data.supplyKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.DEFAULT_FREEZE_STATUS, (EnumWithProtoMetadata)data.defaultFreezeStatus());
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.DEFAULT_KYC_STATUS, (EnumWithProtoMetadata)data.defaultKycStatus());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.DELETED, (boolean)data.deleted());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.AUTO_RENEW_ACCOUNT, (Object)data.autoRenewAccount(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.AUTO_RENEW_PERIOD, (Object)data.autoRenewPeriod(), (arg_0, arg_1) -> Duration.PROTOBUF.write(arg_0, arg_1), arg_0 -> Duration.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.EXPIRY, (Object)data.expiry(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.TOKEN_TYPE, (EnumWithProtoMetadata)data.tokenType());
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.SUPPLY_TYPE, (EnumWithProtoMetadata)data.supplyType());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.MAX_SUPPLY, (long)data.maxSupply());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.FEE_SCHEDULE_KEY, (Object)data.feeScheduleKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.CUSTOM_FEES, data.customFees(), (arg_0, arg_1) -> CustomFee.PROTOBUF.write(arg_0, arg_1), arg_0 -> CustomFee.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.PAUSE_KEY, (Object)data.pauseKey(), (arg_0, arg_1) -> Key.PROTOBUF.write(arg_0, arg_1), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.PAUSE_STATUS, (EnumWithProtoMetadata)data.pauseStatus());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TokenInfoSchema.LEDGER_ID, (RandomAccessData)data.ledgerId());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(TokenInfo data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenInfoSchema.TOKEN_ID, (Object)data.tokenId(), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfString((FieldDefinition)TokenInfoSchema.NAME, (String)data.name());
        size += ProtoWriterTools.sizeOfString((FieldDefinition)TokenInfoSchema.SYMBOL, (String)data.symbol());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)TokenInfoSchema.DECIMALS, (int)data.decimals());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenInfoSchema.TOTAL_SUPPLY, (long)data.totalSupply());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenInfoSchema.TREASURY, (Object)data.treasury(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenInfoSchema.ADMIN_KEY, (Object)data.adminKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenInfoSchema.KYC_KEY, (Object)data.kycKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenInfoSchema.FREEZE_KEY, (Object)data.freezeKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenInfoSchema.WIPE_KEY, (Object)data.wipeKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenInfoSchema.SUPPLY_KEY, (Object)data.supplyKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfEnum((FieldDefinition)TokenInfoSchema.DEFAULT_FREEZE_STATUS, (EnumWithProtoMetadata)data.defaultFreezeStatus());
        size += ProtoWriterTools.sizeOfEnum((FieldDefinition)TokenInfoSchema.DEFAULT_KYC_STATUS, (EnumWithProtoMetadata)data.defaultKycStatus());
        size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)TokenInfoSchema.DELETED, (boolean)data.deleted());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenInfoSchema.AUTO_RENEW_ACCOUNT, (Object)data.autoRenewAccount(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenInfoSchema.AUTO_RENEW_PERIOD, (Object)data.autoRenewPeriod(), arg_0 -> Duration.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenInfoSchema.EXPIRY, (Object)data.expiry(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfString((FieldDefinition)TokenInfoSchema.MEMO, (String)data.memo());
        size += ProtoWriterTools.sizeOfEnum((FieldDefinition)TokenInfoSchema.TOKEN_TYPE, (EnumWithProtoMetadata)data.tokenType());
        size += ProtoWriterTools.sizeOfEnum((FieldDefinition)TokenInfoSchema.SUPPLY_TYPE, (EnumWithProtoMetadata)data.supplyType());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TokenInfoSchema.MAX_SUPPLY, (long)data.maxSupply());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenInfoSchema.FEE_SCHEDULE_KEY, (Object)data.feeScheduleKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TokenInfoSchema.CUSTOM_FEES, data.customFees(), arg_0 -> CustomFee.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TokenInfoSchema.PAUSE_KEY, (Object)data.pauseKey(), arg_0 -> Key.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfEnum((FieldDefinition)TokenInfoSchema.PAUSE_STATUS, (EnumWithProtoMetadata)data.pauseStatus());
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TokenInfoSchema.LEDGER_ID, (RandomAccessData)data.ledgerId());
    }

    public boolean fastEquals(@NonNull TokenInfo item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private TokenInfo parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_tokenId = null;
        String temp_name = "";
        String temp_symbol = "";
        int temp_decimals = 0;
        long temp_totalSupply = 0L;
        Record temp_treasury = null;
        Record temp_adminKey = null;
        Record temp_kycKey = null;
        Record temp_freezeKey = null;
        Record temp_wipeKey = null;
        Record temp_supplyKey = null;
        TokenFreezeStatus temp_defaultFreezeStatus = TokenFreezeStatus.values()[0];
        TokenKycStatus temp_defaultKycStatus = TokenKycStatus.values()[0];
        boolean temp_deleted = false;
        Record temp_autoRenewAccount = null;
        Record temp_autoRenewPeriod = null;
        Record temp_expiry = null;
        String temp_memo = "";
        TokenType temp_tokenType = TokenType.values()[0];
        TokenSupplyType temp_supplyType = TokenSupplyType.values()[0];
        long temp_maxSupply = 0L;
        Record temp_fee_schedule_key = null;
        List temp_custom_fees = Collections.emptyList();
        Record temp_pause_key = null;
        TokenPauseStatus temp_pause_status = TokenPauseStatus.values()[0];
        Bytes temp_ledger_id = Bytes.EMPTY;
        try {
            block30: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TokenInfoSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TokenID)TokenID.PROTOBUF.parseStrict(input) : (TokenID)TokenID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_tokenId = value;
                        continue block30;
                    }
                    case 18: {
                        String value;
                        temp_name = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 26: {
                        String value;
                        temp_symbol = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 32: {
                        int value;
                        temp_decimals = value = ProtoParserTools.readUint32((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 40: {
                        long value;
                        temp_totalSupply = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 50: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_treasury = value;
                        continue block30;
                    }
                    case 58: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_adminKey = value;
                        continue block30;
                    }
                    case 66: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_kycKey = value;
                        continue block30;
                    }
                    case 74: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_freezeKey = value;
                        continue block30;
                    }
                    case 82: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_wipeKey = value;
                        continue block30;
                    }
                    case 90: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_supplyKey = value;
                        continue block30;
                    }
                    case 96: {
                        TokenFreezeStatus value;
                        temp_defaultFreezeStatus = value = TokenFreezeStatus.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block30;
                    }
                    case 104: {
                        TokenKycStatus value;
                        temp_defaultKycStatus = value = TokenKycStatus.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block30;
                    }
                    case 112: {
                        boolean value;
                        temp_deleted = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 122: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_autoRenewAccount = value;
                        continue block30;
                    }
                    case 130: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Duration)Duration.PROTOBUF.parseStrict(input) : (Duration)Duration.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_autoRenewPeriod = value;
                        continue block30;
                    }
                    case 138: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_expiry = value;
                        continue block30;
                    }
                    case 146: {
                        String value;
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 152: {
                        TokenType value;
                        temp_tokenType = value = TokenType.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block30;
                    }
                    case 160: {
                        TokenSupplyType value;
                        temp_supplyType = value = TokenSupplyType.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block30;
                    }
                    case 168: {
                        long value;
                        temp_maxSupply = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block30;
                    }
                    case 178: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_fee_schedule_key = value;
                        continue block30;
                    }
                    case 186: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (CustomFee)CustomFee.PROTOBUF.parseStrict(input) : (CustomFee)CustomFee.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_custom_fees = ProtoParserTools.addToList(temp_custom_fees, (Object)value);
                        continue block30;
                    }
                    case 194: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Key)Key.PROTOBUF.parseStrict(input) : (Key)Key.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_pause_key = value;
                        continue block30;
                    }
                    case 200: {
                        TokenPauseStatus value;
                        temp_pause_status = value = TokenPauseStatus.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block30;
                    }
                    case 210: {
                        Bytes value;
                        temp_ledger_id = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block30;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new TokenInfo((TokenID)temp_tokenId, temp_name, temp_symbol, temp_decimals, temp_totalSupply, (AccountID)temp_treasury, (Key)temp_adminKey, (Key)temp_kycKey, (Key)temp_freezeKey, (Key)temp_wipeKey, (Key)temp_supplyKey, temp_defaultFreezeStatus, temp_defaultKycStatus, temp_deleted, (AccountID)temp_autoRenewAccount, (Duration)temp_autoRenewPeriod, (Timestamp)temp_expiry, temp_memo, temp_tokenType, temp_supplyType, temp_maxSupply, (Key)temp_fee_schedule_key, temp_custom_fees, (Key)temp_pause_key, temp_pause_status, temp_ledger_id);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new TokenInfo((TokenID)temp_tokenId, temp_name, temp_symbol, temp_decimals, temp_totalSupply, (AccountID)temp_treasury, (Key)temp_adminKey, (Key)temp_kycKey, (Key)temp_freezeKey, (Key)temp_wipeKey, (Key)temp_supplyKey, temp_defaultFreezeStatus, temp_defaultKycStatus, temp_deleted, (AccountID)temp_autoRenewAccount, (Duration)temp_autoRenewPeriod, (Timestamp)temp_expiry, temp_memo, temp_tokenType, temp_supplyType, temp_maxSupply, (Key)temp_fee_schedule_key, temp_custom_fees, (Key)temp_pause_key, temp_pause_status, temp_ledger_id);
    }
}

