/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.transaction.codec.AssessedCustomFeeJsonCodec;
import com.hedera.hapi.node.transaction.codec.AssessedCustomFeeProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record AssessedCustomFee(long amount, @Nullable TokenID tokenId, @Nullable AccountID feeCollectorAccountId, @Nullable List<AccountID> effectivePayerAccountId) {
    public static final Codec<AssessedCustomFee> PROTOBUF = new AssessedCustomFeeProtoCodec();
    public static final JsonCodec<AssessedCustomFee> JSON = new AssessedCustomFeeJsonCodec();
    public static final AssessedCustomFee DEFAULT = AssessedCustomFee.newBuilder().build();

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public boolean hasFeeCollectorAccountId() {
        return this.feeCollectorAccountId != null;
    }

    public AccountID feeCollectorAccountIdOrElse(@NonNull AccountID defaultValue) {
        return this.hasFeeCollectorAccountId() ? this.feeCollectorAccountId : defaultValue;
    }

    @NonNull
    public AccountID feeCollectorAccountIdOrThrow() {
        return Objects.requireNonNull(this.feeCollectorAccountId, "Field feeCollectorAccountId is null");
    }

    public void ifFeeCollectorAccountId(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasFeeCollectorAccountId()) {
            ifPresent.accept(this.feeCollectorAccountId);
        }
    }

    public boolean hasEffectivePayerAccountId() {
        return this.effectivePayerAccountId != null;
    }

    public List<AccountID> effectivePayerAccountIdOrElse(@NonNull List<AccountID> defaultValue) {
        return this.hasEffectivePayerAccountId() ? this.effectivePayerAccountId : defaultValue;
    }

    @NonNull
    public List<AccountID> effectivePayerAccountIdOrThrow() {
        return Objects.requireNonNull(this.effectivePayerAccountId, "Field effectivePayerAccountId is null");
    }

    public void ifEffectivePayerAccountId(@NonNull Consumer<List<AccountID>> ifPresent) {
        if (this.hasEffectivePayerAccountId()) {
            ifPresent.accept(this.effectivePayerAccountId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.amount, this.tokenId, this.feeCollectorAccountId, this.effectivePayerAccountId);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private long amount = 0L;
        private TokenID tokenId = null;
        private AccountID feeCollectorAccountId = null;
        private List<AccountID> effectivePayerAccountId = Collections.emptyList();

        public Builder() {
        }

        public Builder(long amount, TokenID tokenId, AccountID feeCollectorAccountId, List<AccountID> effectivePayerAccountId) {
            this.amount = amount;
            this.tokenId = tokenId;
            this.feeCollectorAccountId = feeCollectorAccountId;
            this.effectivePayerAccountId = effectivePayerAccountId;
        }

        public AssessedCustomFee build() {
            return new AssessedCustomFee(this.amount, this.tokenId, this.feeCollectorAccountId, this.effectivePayerAccountId);
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder tokenId(TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder feeCollectorAccountId(AccountID feeCollectorAccountId) {
            this.feeCollectorAccountId = feeCollectorAccountId;
            return this;
        }

        public Builder feeCollectorAccountId(AccountID.Builder builder) {
            this.feeCollectorAccountId = builder.build();
            return this;
        }

        public Builder effectivePayerAccountId(List<AccountID> effectivePayerAccountId) {
            this.effectivePayerAccountId = effectivePayerAccountId;
            return this;
        }

        public Builder effectivePayerAccountId(AccountID ... values) {
            this.effectivePayerAccountId = List.of(values);
            return this;
        }
    }
}

