/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.transaction.codec.ExchangeRateJsonCodec;
import com.hedera.hapi.node.transaction.codec.ExchangeRateProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ExchangeRate(int hbarEquiv, int centEquiv, @Nullable TimestampSeconds expirationTime) {
    public static final Codec<ExchangeRate> PROTOBUF = new ExchangeRateProtoCodec();
    public static final JsonCodec<ExchangeRate> JSON = new ExchangeRateJsonCodec();
    public static final ExchangeRate DEFAULT = ExchangeRate.newBuilder().build();

    public boolean hasExpirationTime() {
        return this.expirationTime != null;
    }

    public TimestampSeconds expirationTimeOrElse(@NonNull TimestampSeconds defaultValue) {
        return this.hasExpirationTime() ? this.expirationTime : defaultValue;
    }

    @NonNull
    public TimestampSeconds expirationTimeOrThrow() {
        return Objects.requireNonNull(this.expirationTime, "Field expirationTime is null");
    }

    public void ifExpirationTime(@NonNull Consumer<TimestampSeconds> ifPresent) {
        if (this.hasExpirationTime()) {
            ifPresent.accept(this.expirationTime);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.hbarEquiv, this.centEquiv, this.expirationTime);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private int hbarEquiv = 0;
        private int centEquiv = 0;
        private TimestampSeconds expirationTime = null;

        public Builder() {
        }

        public Builder(int hbarEquiv, int centEquiv, TimestampSeconds expirationTime) {
            this.hbarEquiv = hbarEquiv;
            this.centEquiv = centEquiv;
            this.expirationTime = expirationTime;
        }

        public ExchangeRate build() {
            return new ExchangeRate(this.hbarEquiv, this.centEquiv, this.expirationTime);
        }

        public Builder hbarEquiv(int hbarEquiv) {
            this.hbarEquiv = hbarEquiv;
            return this;
        }

        public Builder centEquiv(int centEquiv) {
            this.centEquiv = centEquiv;
            return this;
        }

        public Builder expirationTime(TimestampSeconds expirationTime) {
            this.expirationTime = expirationTime;
            return this;
        }

        public Builder expirationTime(TimestampSeconds.Builder builder) {
            this.expirationTime = builder.build();
            return this;
        }
    }
}

