/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.Fraction;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.codec.RoyaltyFeeJsonCodec;
import com.hedera.hapi.node.transaction.codec.RoyaltyFeeProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record RoyaltyFee(@Nullable Fraction exchangeValueFraction, @Nullable FixedFee fallbackFee) {
    public static final Codec<RoyaltyFee> PROTOBUF = new RoyaltyFeeProtoCodec();
    public static final JsonCodec<RoyaltyFee> JSON = new RoyaltyFeeJsonCodec();
    public static final RoyaltyFee DEFAULT = RoyaltyFee.newBuilder().build();

    public boolean hasExchangeValueFraction() {
        return this.exchangeValueFraction != null;
    }

    public Fraction exchangeValueFractionOrElse(@NonNull Fraction defaultValue) {
        return this.hasExchangeValueFraction() ? this.exchangeValueFraction : defaultValue;
    }

    @NonNull
    public Fraction exchangeValueFractionOrThrow() {
        return Objects.requireNonNull(this.exchangeValueFraction, "Field exchangeValueFraction is null");
    }

    public void ifExchangeValueFraction(@NonNull Consumer<Fraction> ifPresent) {
        if (this.hasExchangeValueFraction()) {
            ifPresent.accept(this.exchangeValueFraction);
        }
    }

    public boolean hasFallbackFee() {
        return this.fallbackFee != null;
    }

    public FixedFee fallbackFeeOrElse(@NonNull FixedFee defaultValue) {
        return this.hasFallbackFee() ? this.fallbackFee : defaultValue;
    }

    @NonNull
    public FixedFee fallbackFeeOrThrow() {
        return Objects.requireNonNull(this.fallbackFee, "Field fallbackFee is null");
    }

    public void ifFallbackFee(@NonNull Consumer<FixedFee> ifPresent) {
        if (this.hasFallbackFee()) {
            ifPresent.accept(this.fallbackFee);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.exchangeValueFraction, this.fallbackFee);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Fraction exchangeValueFraction = null;
        private FixedFee fallbackFee = null;

        public Builder() {
        }

        public Builder(Fraction exchangeValueFraction, FixedFee fallbackFee) {
            this.exchangeValueFraction = exchangeValueFraction;
            this.fallbackFee = fallbackFee;
        }

        public RoyaltyFee build() {
            return new RoyaltyFee(this.exchangeValueFraction, this.fallbackFee);
        }

        public Builder exchangeValueFraction(Fraction exchangeValueFraction) {
            this.exchangeValueFraction = exchangeValueFraction;
            return this;
        }

        public Builder exchangeValueFraction(Fraction.Builder builder) {
            this.exchangeValueFraction = builder.build();
            return this;
        }

        public Builder fallbackFee(FixedFee fallbackFee) {
            this.fallbackFee = fallbackFee;
            return this;
        }

        public Builder fallbackFee(FixedFee.Builder builder) {
            this.fallbackFee = builder.build();
            return this;
        }
    }
}

