/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.transaction.codec.ThrottleGroupJsonCodec;
import com.hedera.hapi.node.transaction.codec.ThrottleGroupProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import java.util.Collections;
import java.util.List;

public record ThrottleGroup(List<HederaFunctionality> operations, long milliOpsPerSec) {
    public static final Codec<ThrottleGroup> PROTOBUF = new ThrottleGroupProtoCodec();
    public static final JsonCodec<ThrottleGroup> JSON = new ThrottleGroupJsonCodec();
    public static final ThrottleGroup DEFAULT = ThrottleGroup.newBuilder().build();

    public Builder copyBuilder() {
        return new Builder(this.operations, this.milliOpsPerSec);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private List<HederaFunctionality> operations = Collections.emptyList();
        private long milliOpsPerSec = 0L;

        public Builder() {
        }

        public Builder(List<HederaFunctionality> operations, long milliOpsPerSec) {
            this.operations = operations;
            this.milliOpsPerSec = milliOpsPerSec;
        }

        public ThrottleGroup build() {
            return new ThrottleGroup(this.operations, this.milliOpsPerSec);
        }

        public Builder operations(List<HederaFunctionality> operations) {
            this.operations = operations;
            return this;
        }

        public Builder operations(HederaFunctionality ... values) {
            this.operations = List.of(values);
            return this;
        }

        public Builder milliOpsPerSec(long milliOpsPerSec) {
            this.milliOpsPerSec = milliOpsPerSec;
            return this;
        }
    }
}

