/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.transaction.CustomFee;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.FractionalFee;
import com.hedera.hapi.node.transaction.RoyaltyFee;
import com.hedera.hapi.node.transaction.schema.CustomFeeSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class CustomFeeProtoCodec
implements Codec<CustomFee> {
    public static final OneOf<CustomFee.FeeOneOfType> FEE_UNSET = new OneOf((Object)CustomFee.FeeOneOfType.UNSET, null);

    @NonNull
    public CustomFee parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public CustomFee parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull CustomFee data, @NonNull WritableSequentialData out) throws IOException {
        if (data.fee().kind() == CustomFee.FeeOneOfType.FIXED_FEE) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)CustomFeeSchema.FIXED_FEE, (Object)((FixedFee)data.fee().as()), (arg_0, arg_1) -> FixedFee.PROTOBUF.write(arg_0, arg_1), arg_0 -> FixedFee.PROTOBUF.measureRecord(arg_0));
        }
        if (data.fee().kind() == CustomFee.FeeOneOfType.FRACTIONAL_FEE) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)CustomFeeSchema.FRACTIONAL_FEE, (Object)((FractionalFee)data.fee().as()), (arg_0, arg_1) -> FractionalFee.PROTOBUF.write(arg_0, arg_1), arg_0 -> FractionalFee.PROTOBUF.measureRecord(arg_0));
        }
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)CustomFeeSchema.FEE_COLLECTOR_ACCOUNT_ID, (Object)data.feeCollectorAccountId(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        if (data.fee().kind() == CustomFee.FeeOneOfType.ROYALTY_FEE) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)CustomFeeSchema.ROYALTY_FEE, (Object)((RoyaltyFee)data.fee().as()), (arg_0, arg_1) -> RoyaltyFee.PROTOBUF.write(arg_0, arg_1), arg_0 -> RoyaltyFee.PROTOBUF.measureRecord(arg_0));
        }
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)CustomFeeSchema.ALL_COLLECTORS_ARE_EXEMPT, (boolean)data.allCollectorsAreExempt());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(CustomFee data) {
        int size = 0;
        if (data.fee().kind() == CustomFee.FeeOneOfType.FIXED_FEE) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)CustomFeeSchema.FIXED_FEE, (Object)((FixedFee)data.fee().as()), arg_0 -> FixedFee.PROTOBUF.measureRecord(arg_0));
        }
        if (data.fee().kind() == CustomFee.FeeOneOfType.FRACTIONAL_FEE) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)CustomFeeSchema.FRACTIONAL_FEE, (Object)((FractionalFee)data.fee().as()), arg_0 -> FractionalFee.PROTOBUF.measureRecord(arg_0));
        }
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)CustomFeeSchema.FEE_COLLECTOR_ACCOUNT_ID, (Object)data.feeCollectorAccountId(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        if (data.fee().kind() == CustomFee.FeeOneOfType.ROYALTY_FEE) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)CustomFeeSchema.ROYALTY_FEE, (Object)((RoyaltyFee)data.fee().as()), arg_0 -> RoyaltyFee.PROTOBUF.measureRecord(arg_0));
        }
        return size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)CustomFeeSchema.ALL_COLLECTORS_ARE_EXEMPT, (boolean)data.allCollectorsAreExempt());
    }

    public boolean fastEquals(@NonNull CustomFee item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private CustomFee parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        OneOf temp_fee = FEE_UNSET;
        Record temp_fee_collector_account_id = null;
        boolean temp_all_collectors_are_exempt = false;
        try {
            block9: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = CustomFeeSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (FixedFee)FixedFee.PROTOBUF.parseStrict(input) : (FixedFee)FixedFee.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_fee = new OneOf((Object)CustomFee.FeeOneOfType.FIXED_FEE, (Object)value);
                        continue block9;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (FractionalFee)FractionalFee.PROTOBUF.parseStrict(input) : (FractionalFee)FractionalFee.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_fee = new OneOf((Object)CustomFee.FeeOneOfType.FRACTIONAL_FEE, (Object)value);
                        continue block9;
                    }
                    case 34: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (RoyaltyFee)RoyaltyFee.PROTOBUF.parseStrict(input) : (RoyaltyFee)RoyaltyFee.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_fee = new OneOf((Object)CustomFee.FeeOneOfType.ROYALTY_FEE, (Object)value);
                        continue block9;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_fee_collector_account_id = value;
                        continue block9;
                    }
                    case 40: {
                        boolean value;
                        temp_all_collectors_are_exempt = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block9;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new CustomFee((OneOf<CustomFee.FeeOneOfType>)temp_fee, (AccountID)temp_fee_collector_account_id, temp_all_collectors_are_exempt);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new CustomFee((OneOf<CustomFee.FeeOneOfType>)temp_fee, (AccountID)temp_fee_collector_account_id, temp_all_collectors_are_exempt);
    }
}

