/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.transaction.ExchangeRate;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.hapi.node.transaction.schema.ExchangeRateSetSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class ExchangeRateSetProtoCodec
implements Codec<ExchangeRateSet> {
    @NonNull
    public ExchangeRateSet parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ExchangeRateSet parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ExchangeRateSet data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ExchangeRateSetSchema.CURRENT_RATE, (Object)data.currentRate(), (arg_0, arg_1) -> ExchangeRate.PROTOBUF.write(arg_0, arg_1), arg_0 -> ExchangeRate.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ExchangeRateSetSchema.NEXT_RATE, (Object)data.nextRate(), (arg_0, arg_1) -> ExchangeRate.PROTOBUF.write(arg_0, arg_1), arg_0 -> ExchangeRate.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ExchangeRateSet data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ExchangeRateSetSchema.CURRENT_RATE, (Object)data.currentRate(), arg_0 -> ExchangeRate.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ExchangeRateSetSchema.NEXT_RATE, (Object)data.nextRate(), arg_0 -> ExchangeRate.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull ExchangeRateSet item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ExchangeRateSet parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        ExchangeRate temp_currentRate = null;
        ExchangeRate temp_nextRate = null;
        try {
            block6: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ExchangeRateSetSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        ExchangeRate value = strictMode ? (ExchangeRate)ExchangeRate.PROTOBUF.parseStrict(input) : (ExchangeRate)ExchangeRate.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_currentRate = value;
                        continue block6;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        ExchangeRate value = strictMode ? (ExchangeRate)ExchangeRate.PROTOBUF.parseStrict(input) : (ExchangeRate)ExchangeRate.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_nextRate = value;
                        continue block6;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ExchangeRateSet(temp_currentRate, temp_nextRate);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ExchangeRateSet(temp_currentRate, temp_nextRate);
    }
}

