/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.transaction.FixedFee;
import com.hedera.hapi.node.transaction.schema.FixedFeeSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class FixedFeeProtoCodec
implements Codec<FixedFee> {
    @NonNull
    public FixedFee parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public FixedFee parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull FixedFee data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)FixedFeeSchema.AMOUNT, (long)data.amount());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FixedFeeSchema.DENOMINATING_TOKEN_ID, (Object)data.denominatingTokenId(), (arg_0, arg_1) -> TokenID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(FixedFee data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)FixedFeeSchema.AMOUNT, (long)data.amount());
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FixedFeeSchema.DENOMINATING_TOKEN_ID, (Object)data.denominatingTokenId(), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull FixedFee item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private FixedFee parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        long temp_amount = 0L;
        TokenID temp_denominating_token_id = null;
        try {
            block6: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = FixedFeeSchema.getField(field);
                switch (tag) {
                    case 8: {
                        long value;
                        temp_amount = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block6;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        TokenID value = strictMode ? (TokenID)TokenID.PROTOBUF.parseStrict(input) : (TokenID)TokenID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_denominating_token_id = value;
                        continue block6;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new FixedFee(temp_amount, temp_denominating_token_id);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new FixedFee(temp_amount, temp_denominating_token_id);
    }
}

