/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.Fraction;
import com.hedera.hapi.node.transaction.FractionalFee;
import com.hedera.hapi.node.transaction.schema.FractionalFeeSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class FractionalFeeProtoCodec
implements Codec<FractionalFee> {
    @NonNull
    public FractionalFee parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public FractionalFee parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull FractionalFee data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FractionalFeeSchema.FRACTIONAL_AMOUNT, (Object)data.fractionalAmount(), (arg_0, arg_1) -> Fraction.PROTOBUF.write(arg_0, arg_1), arg_0 -> Fraction.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)FractionalFeeSchema.MINIMUM_AMOUNT, (long)data.minimumAmount());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)FractionalFeeSchema.MAXIMUM_AMOUNT, (long)data.maximumAmount());
        ProtoWriterTools.writeBoolean((WritableSequentialData)out, (FieldDefinition)FractionalFeeSchema.NET_OF_TRANSFERS, (boolean)data.netOfTransfers());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(FractionalFee data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FractionalFeeSchema.FRACTIONAL_AMOUNT, (Object)data.fractionalAmount(), arg_0 -> Fraction.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)FractionalFeeSchema.MINIMUM_AMOUNT, (long)data.minimumAmount());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)FractionalFeeSchema.MAXIMUM_AMOUNT, (long)data.maximumAmount());
        return size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)FractionalFeeSchema.NET_OF_TRANSFERS, (boolean)data.netOfTransfers());
    }

    public boolean fastEquals(@NonNull FractionalFee item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private FractionalFee parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Fraction temp_fractional_amount = null;
        long temp_minimum_amount = 0L;
        long temp_maximum_amount = 0L;
        boolean temp_net_of_transfers = false;
        try {
            block8: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = FractionalFeeSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Fraction value = strictMode ? (Fraction)Fraction.PROTOBUF.parseStrict(input) : (Fraction)Fraction.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_fractional_amount = value;
                        continue block8;
                    }
                    case 16: {
                        long value;
                        temp_minimum_amount = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 24: {
                        long value;
                        temp_maximum_amount = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block8;
                    }
                    case 32: {
                        boolean value;
                        temp_net_of_transfers = value = ProtoParserTools.readBool((ReadableSequentialData)input);
                        continue block8;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new FractionalFee(temp_fractional_amount, temp_minimum_amount, temp_maximum_amount, temp_net_of_transfers);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new FractionalFee(temp_fractional_amount, temp_minimum_amount, temp_maximum_amount, temp_net_of_transfers);
    }
}

