/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.Fraction;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.transaction.NodeStake;
import com.hedera.hapi.node.transaction.NodeStakeUpdateTransactionBody;
import com.hedera.hapi.node.transaction.schema.NodeStakeUpdateTransactionBodySchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class NodeStakeUpdateTransactionBodyProtoCodec
implements Codec<NodeStakeUpdateTransactionBody> {
    @NonNull
    public NodeStakeUpdateTransactionBody parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public NodeStakeUpdateTransactionBody parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull NodeStakeUpdateTransactionBody data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.END_OF_STAKING_PERIOD, (Object)data.endOfStakingPeriod(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.NODE_STAKE, data.nodeStake(), (arg_0, arg_1) -> NodeStake.PROTOBUF.write(arg_0, arg_1), arg_0 -> NodeStake.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.MAX_STAKING_REWARD_RATE_PER_HBAR, (long)data.maxStakingRewardRatePerHbar());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.NODE_REWARD_FEE_FRACTION, (Object)data.nodeRewardFeeFraction(), (arg_0, arg_1) -> Fraction.PROTOBUF.write(arg_0, arg_1), arg_0 -> Fraction.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_PERIODS_STORED, (long)data.stakingPeriodsStored());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_PERIOD, (long)data.stakingPeriod());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_REWARD_FEE_FRACTION, (Object)data.stakingRewardFeeFraction(), (arg_0, arg_1) -> Fraction.PROTOBUF.write(arg_0, arg_1), arg_0 -> Fraction.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_START_THRESHOLD, (long)data.stakingStartThreshold());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_REWARD_RATE, (long)data.stakingRewardRate());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.RESERVED_STAKING_REWARDS, (long)data.reservedStakingRewards());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.UNRESERVED_STAKING_REWARD_BALANCE, (long)data.unreservedStakingRewardBalance());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.REWARD_BALANCE_THRESHOLD, (long)data.rewardBalanceThreshold());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.MAX_STAKE_REWARDED, (long)data.maxStakeRewarded());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)NodeStakeUpdateTransactionBodySchema.MAX_TOTAL_REWARD, (long)data.maxTotalReward());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(NodeStakeUpdateTransactionBody data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeStakeUpdateTransactionBodySchema.END_OF_STAKING_PERIOD, (Object)data.endOfStakingPeriod(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)NodeStakeUpdateTransactionBodySchema.NODE_STAKE, data.nodeStake(), arg_0 -> NodeStake.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.MAX_STAKING_REWARD_RATE_PER_HBAR, (long)data.maxStakingRewardRatePerHbar());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeStakeUpdateTransactionBodySchema.NODE_REWARD_FEE_FRACTION, (Object)data.nodeRewardFeeFraction(), arg_0 -> Fraction.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_PERIODS_STORED, (long)data.stakingPeriodsStored());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_PERIOD, (long)data.stakingPeriod());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_REWARD_FEE_FRACTION, (Object)data.stakingRewardFeeFraction(), arg_0 -> Fraction.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_START_THRESHOLD, (long)data.stakingStartThreshold());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.STAKING_REWARD_RATE, (long)data.stakingRewardRate());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.RESERVED_STAKING_REWARDS, (long)data.reservedStakingRewards());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.UNRESERVED_STAKING_REWARD_BALANCE, (long)data.unreservedStakingRewardBalance());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.REWARD_BALANCE_THRESHOLD, (long)data.rewardBalanceThreshold());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.MAX_STAKE_REWARDED, (long)data.maxStakeRewarded());
        return size += ProtoWriterTools.sizeOfLong((FieldDefinition)NodeStakeUpdateTransactionBodySchema.MAX_TOTAL_REWARD, (long)data.maxTotalReward());
    }

    public boolean fastEquals(@NonNull NodeStakeUpdateTransactionBody item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private NodeStakeUpdateTransactionBody parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_end_of_staking_period = null;
        List temp_node_stake = Collections.emptyList();
        long temp_max_staking_reward_rate_per_hbar = 0L;
        Record temp_node_reward_fee_fraction = null;
        long temp_staking_periods_stored = 0L;
        long temp_staking_period = 0L;
        Record temp_staking_reward_fee_fraction = null;
        long temp_staking_start_threshold = 0L;
        long temp_staking_reward_rate = 0L;
        long temp_reserved_staking_rewards = 0L;
        long temp_unreserved_staking_reward_balance = 0L;
        long temp_reward_balance_threshold = 0L;
        long temp_max_stake_rewarded = 0L;
        long temp_max_total_reward = 0L;
        try {
            block18: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = NodeStakeUpdateTransactionBodySchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_end_of_staking_period = value;
                        continue block18;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (NodeStake)NodeStake.PROTOBUF.parseStrict(input) : (NodeStake)NodeStake.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_node_stake = ProtoParserTools.addToList(temp_node_stake, (Object)value);
                        continue block18;
                    }
                    case 24: {
                        long value;
                        temp_max_staking_reward_rate_per_hbar = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block18;
                    }
                    case 34: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Fraction)Fraction.PROTOBUF.parseStrict(input) : (Fraction)Fraction.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_node_reward_fee_fraction = value;
                        continue block18;
                    }
                    case 40: {
                        long value;
                        temp_staking_periods_stored = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block18;
                    }
                    case 48: {
                        long value;
                        temp_staking_period = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block18;
                    }
                    case 58: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Fraction)Fraction.PROTOBUF.parseStrict(input) : (Fraction)Fraction.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_staking_reward_fee_fraction = value;
                        continue block18;
                    }
                    case 64: {
                        long value;
                        temp_staking_start_threshold = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block18;
                    }
                    case 72: {
                        long value;
                        temp_staking_reward_rate = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block18;
                    }
                    case 80: {
                        long value;
                        temp_reserved_staking_rewards = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block18;
                    }
                    case 88: {
                        long value;
                        temp_unreserved_staking_reward_balance = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block18;
                    }
                    case 96: {
                        long value;
                        temp_reward_balance_threshold = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block18;
                    }
                    case 104: {
                        long value;
                        temp_max_stake_rewarded = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block18;
                    }
                    case 112: {
                        long value;
                        temp_max_total_reward = value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        continue block18;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new NodeStakeUpdateTransactionBody((Timestamp)temp_end_of_staking_period, temp_node_stake, temp_max_staking_reward_rate_per_hbar, (Fraction)temp_node_reward_fee_fraction, temp_staking_periods_stored, temp_staking_period, (Fraction)temp_staking_reward_fee_fraction, temp_staking_start_threshold, temp_staking_reward_rate, temp_reserved_staking_rewards, temp_unreserved_staking_reward_balance, temp_reward_balance_threshold, temp_max_stake_rewarded, temp_max_total_reward);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new NodeStakeUpdateTransactionBody((Timestamp)temp_end_of_staking_period, temp_node_stake, temp_max_staking_reward_rate_per_hbar, (Fraction)temp_node_reward_fee_fraction, temp_staking_periods_stored, temp_staking_period, (Fraction)temp_staking_reward_fee_fraction, temp_staking_start_threshold, temp_staking_reward_rate, temp_reserved_staking_rewards, temp_unreserved_staking_reward_balance, temp_reward_balance_threshold, temp_max_stake_rewarded, temp_max_total_reward);
    }
}

