/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TopicID;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.transaction.ExchangeRateSet;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.schema.TransactionReceiptSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class TransactionReceiptProtoCodec
implements Codec<TransactionReceipt> {
    @NonNull
    public TransactionReceipt parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public TransactionReceipt parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull TransactionReceipt data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.STATUS, (EnumWithProtoMetadata)data.status());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.ACCOUNT_ID, (Object)data.accountID(), (arg_0, arg_1) -> AccountID.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.FILE_ID, (Object)data.fileID(), (arg_0, arg_1) -> FileID.PROTOBUF.write(arg_0, arg_1), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.CONTRACT_ID, (Object)data.contractID(), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.EXCHANGE_RATE, (Object)data.exchangeRate(), (arg_0, arg_1) -> ExchangeRateSet.PROTOBUF.write(arg_0, arg_1), arg_0 -> ExchangeRateSet.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.TOPIC_ID, (Object)data.topicID(), (arg_0, arg_1) -> TopicID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TopicID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.TOPIC_SEQUENCE_NUMBER, (long)data.topicSequenceNumber());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.TOPIC_RUNNING_HASH, (RandomAccessData)data.topicRunningHash());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.TOPIC_RUNNING_HASH_VERSION, (long)data.topicRunningHashVersion());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.TOKEN_ID, (Object)data.tokenID(), (arg_0, arg_1) -> TokenID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.NEW_TOTAL_SUPPLY, (long)data.newTotalSupply());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.SCHEDULE_ID, (Object)data.scheduleID(), (arg_0, arg_1) -> ScheduleID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ScheduleID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.SCHEDULED_TRANSACTION_ID, (Object)data.scheduledTransactionID(), (arg_0, arg_1) -> TransactionID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TransactionID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeLongList((WritableSequentialData)out, (FieldDefinition)TransactionReceiptSchema.SERIAL_NUMBERS, data.serialNumbers());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(TransactionReceipt data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfEnum((FieldDefinition)TransactionReceiptSchema.STATUS, (EnumWithProtoMetadata)data.status());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionReceiptSchema.ACCOUNT_ID, (Object)data.accountID(), arg_0 -> AccountID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionReceiptSchema.FILE_ID, (Object)data.fileID(), arg_0 -> FileID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionReceiptSchema.CONTRACT_ID, (Object)data.contractID(), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionReceiptSchema.EXCHANGE_RATE, (Object)data.exchangeRate(), arg_0 -> ExchangeRateSet.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionReceiptSchema.TOPIC_ID, (Object)data.topicID(), arg_0 -> TopicID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TransactionReceiptSchema.TOPIC_SEQUENCE_NUMBER, (long)data.topicSequenceNumber());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionReceiptSchema.TOPIC_RUNNING_HASH, (RandomAccessData)data.topicRunningHash());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TransactionReceiptSchema.TOPIC_RUNNING_HASH_VERSION, (long)data.topicRunningHashVersion());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionReceiptSchema.TOKEN_ID, (Object)data.tokenID(), arg_0 -> TokenID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TransactionReceiptSchema.NEW_TOTAL_SUPPLY, (long)data.newTotalSupply());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionReceiptSchema.SCHEDULE_ID, (Object)data.scheduleID(), arg_0 -> ScheduleID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionReceiptSchema.SCHEDULED_TRANSACTION_ID, (Object)data.scheduledTransactionID(), arg_0 -> TransactionID.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfLongList((FieldDefinition)TransactionReceiptSchema.SERIAL_NUMBERS, data.serialNumbers());
    }

    public boolean fastEquals(@NonNull TransactionReceipt item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private TransactionReceipt parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        ResponseCodeEnum temp_status = ResponseCodeEnum.values()[0];
        Record temp_accountID = null;
        Record temp_fileID = null;
        Record temp_contractID = null;
        Record temp_exchangeRate = null;
        Record temp_topicID = null;
        long temp_topicSequenceNumber = 0L;
        Bytes temp_topicRunningHash = Bytes.EMPTY;
        long temp_topicRunningHashVersion = 0L;
        Record temp_tokenID = null;
        long temp_newTotalSupply = 0L;
        Record temp_scheduleID = null;
        Record temp_scheduledTransactionID = null;
        List temp_serialNumbers = Collections.emptyList();
        try {
            block19: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TransactionReceiptSchema.getField(field);
                switch (tag) {
                    case 8: {
                        ResponseCodeEnum value;
                        temp_status = value = ResponseCodeEnum.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block19;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountID)AccountID.PROTOBUF.parseStrict(input) : (AccountID)AccountID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_accountID = value;
                        continue block19;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (FileID)FileID.PROTOBUF.parseStrict(input) : (FileID)FileID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_fileID = value;
                        continue block19;
                    }
                    case 34: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_contractID = value;
                        continue block19;
                    }
                    case 42: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ExchangeRateSet)ExchangeRateSet.PROTOBUF.parseStrict(input) : (ExchangeRateSet)ExchangeRateSet.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_exchangeRate = value;
                        continue block19;
                    }
                    case 50: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TopicID)TopicID.PROTOBUF.parseStrict(input) : (TopicID)TopicID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_topicID = value;
                        continue block19;
                    }
                    case 56: {
                        long value;
                        temp_topicSequenceNumber = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 66: {
                        Bytes value;
                        temp_topicRunningHash = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 72: {
                        long value;
                        temp_topicRunningHashVersion = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 82: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TokenID)TokenID.PROTOBUF.parseStrict(input) : (TokenID)TokenID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_tokenID = value;
                        continue block19;
                    }
                    case 88: {
                        long value;
                        temp_newTotalSupply = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block19;
                    }
                    case 98: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ScheduleID)ScheduleID.PROTOBUF.parseStrict(input) : (ScheduleID)ScheduleID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_scheduleID = value;
                        continue block19;
                    }
                    case 106: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TransactionID)TransactionID.PROTOBUF.parseStrict(input) : (TransactionID)TransactionID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_scheduledTransactionID = value;
                        continue block19;
                    }
                    case 112: {
                        long value = ProtoParserTools.readInt64((ReadableSequentialData)input);
                        temp_serialNumbers = ProtoParserTools.addToList(temp_serialNumbers, (Object)value);
                        continue block19;
                    }
                    case 114: {
                        int length = input.readVarInt(false);
                        long beforeLimit = input.limit();
                        input.limit(input.position() + (long)length);
                        while (input.hasRemaining()) {
                            temp_serialNumbers = ProtoParserTools.addToList((List)temp_serialNumbers, (Object)ProtoParserTools.readInt64((ReadableSequentialData)input));
                        }
                        input.limit(beforeLimit);
                        continue block19;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new TransactionReceipt(temp_status, (AccountID)temp_accountID, (FileID)temp_fileID, (ContractID)temp_contractID, (ExchangeRateSet)temp_exchangeRate, (TopicID)temp_topicID, temp_topicSequenceNumber, temp_topicRunningHash, temp_topicRunningHashVersion, (TokenID)temp_tokenID, temp_newTotalSupply, (ScheduleID)temp_scheduleID, (TransactionID)temp_scheduledTransactionID, temp_serialNumbers);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new TransactionReceipt(temp_status, (AccountID)temp_accountID, (FileID)temp_fileID, (ContractID)temp_contractID, (ExchangeRateSet)temp_exchangeRate, (TopicID)temp_topicID, temp_topicSequenceNumber, temp_topicRunningHash, temp_topicRunningHashVersion, (TokenID)temp_tokenID, temp_newTotalSupply, (ScheduleID)temp_scheduleID, (TransactionID)temp_scheduledTransactionID, temp_serialNumbers);
    }
}

