/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.transaction.codec;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenAssociation;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.contract.ContractFunctionResult;
import com.hedera.hapi.node.transaction.AssessedCustomFee;
import com.hedera.hapi.node.transaction.TransactionReceipt;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.hapi.node.transaction.schema.TransactionRecordSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class TransactionRecordProtoCodec
implements Codec<TransactionRecord> {
    public static final OneOf<TransactionRecord.BodyOneOfType> BODY_UNSET = new OneOf((Object)TransactionRecord.BodyOneOfType.UNSET, null);
    public static final OneOf<TransactionRecord.EntropyOneOfType> ENTROPY_UNSET = new OneOf((Object)TransactionRecord.EntropyOneOfType.UNSET, null);

    @NonNull
    public TransactionRecord parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public TransactionRecord parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull TransactionRecord data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.RECEIPT, (Object)data.receipt(), (arg_0, arg_1) -> TransactionReceipt.PROTOBUF.write(arg_0, arg_1), arg_0 -> TransactionReceipt.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.TRANSACTION_HASH, (RandomAccessData)data.transactionHash());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.CONSENSUS_TIMESTAMP, (Object)data.consensusTimestamp(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.TRANSACTION_ID, (Object)data.transactionID(), (arg_0, arg_1) -> TransactionID.PROTOBUF.write(arg_0, arg_1), arg_0 -> TransactionID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeString((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.MEMO, (String)data.memo());
        ProtoWriterTools.writeLong((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.TRANSACTION_FEE, (long)data.transactionFee());
        if (data.body().kind() == TransactionRecord.BodyOneOfType.CONTRACT_CALL_RESULT) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.CONTRACT_CALL_RESULT, (Object)((ContractFunctionResult)data.body().as()), (arg_0, arg_1) -> ContractFunctionResult.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractFunctionResult.PROTOBUF.measureRecord(arg_0));
        }
        if (data.body().kind() == TransactionRecord.BodyOneOfType.CONTRACT_CREATE_RESULT) {
            ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.CONTRACT_CREATE_RESULT, (Object)((ContractFunctionResult)data.body().as()), (arg_0, arg_1) -> ContractFunctionResult.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractFunctionResult.PROTOBUF.measureRecord(arg_0));
        }
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.TRANSFER_LIST, (Object)data.transferList(), (arg_0, arg_1) -> TransferList.PROTOBUF.write(arg_0, arg_1), arg_0 -> TransferList.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.TOKEN_TRANSFER_LISTS, data.tokenTransferLists(), (arg_0, arg_1) -> TokenTransferList.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenTransferList.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.SCHEDULE_REF, (Object)data.scheduleRef(), (arg_0, arg_1) -> ScheduleID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ScheduleID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.ASSESSED_CUSTOM_FEES, data.assessedCustomFees(), (arg_0, arg_1) -> AssessedCustomFee.PROTOBUF.write(arg_0, arg_1), arg_0 -> AssessedCustomFee.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.AUTOMATIC_TOKEN_ASSOCIATIONS, data.automaticTokenAssociations(), (arg_0, arg_1) -> TokenAssociation.PROTOBUF.write(arg_0, arg_1), arg_0 -> TokenAssociation.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.PARENT_CONSENSUS_TIMESTAMP, (Object)data.parentConsensusTimestamp(), (arg_0, arg_1) -> Timestamp.PROTOBUF.write(arg_0, arg_1), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.ALIAS, (RandomAccessData)data.alias());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.ETHEREUM_HASH, (RandomAccessData)data.ethereumHash());
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.PAID_STAKING_REWARDS, data.paidStakingRewards(), (arg_0, arg_1) -> AccountAmount.PROTOBUF.write(arg_0, arg_1), arg_0 -> AccountAmount.PROTOBUF.measureRecord(arg_0));
        if (data.entropy().kind() == TransactionRecord.EntropyOneOfType.PRNG_BYTES) {
            ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.PRNG_BYTES, (RandomAccessData)((RandomAccessData)data.entropy().as()));
        }
        if (data.entropy().kind() == TransactionRecord.EntropyOneOfType.PRNG_NUMBER) {
            ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.PRNG_NUMBER, (int)((Integer)data.entropy().as()));
        }
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)TransactionRecordSchema.EVM_ADDRESS, (RandomAccessData)data.evmAddress());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(TransactionRecord data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.RECEIPT, (Object)data.receipt(), arg_0 -> TransactionReceipt.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.TRANSACTION_HASH, (RandomAccessData)data.transactionHash());
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.CONSENSUS_TIMESTAMP, (Object)data.consensusTimestamp(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.TRANSACTION_ID, (Object)data.transactionID(), arg_0 -> TransactionID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfString((FieldDefinition)TransactionRecordSchema.MEMO, (String)data.memo());
        size += ProtoWriterTools.sizeOfLong((FieldDefinition)TransactionRecordSchema.TRANSACTION_FEE, (long)data.transactionFee());
        if (data.body().kind() == TransactionRecord.BodyOneOfType.CONTRACT_CALL_RESULT) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.CONTRACT_CALL_RESULT, (Object)((ContractFunctionResult)data.body().as()), arg_0 -> ContractFunctionResult.PROTOBUF.measureRecord(arg_0));
        }
        if (data.body().kind() == TransactionRecord.BodyOneOfType.CONTRACT_CREATE_RESULT) {
            size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.CONTRACT_CREATE_RESULT, (Object)((ContractFunctionResult)data.body().as()), arg_0 -> ContractFunctionResult.PROTOBUF.measureRecord(arg_0));
        }
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.TRANSFER_LIST, (Object)data.transferList(), arg_0 -> TransferList.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransactionRecordSchema.TOKEN_TRANSFER_LISTS, data.tokenTransferLists(), arg_0 -> TokenTransferList.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.SCHEDULE_REF, (Object)data.scheduleRef(), arg_0 -> ScheduleID.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransactionRecordSchema.ASSESSED_CUSTOM_FEES, data.assessedCustomFees(), arg_0 -> AssessedCustomFee.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransactionRecordSchema.AUTOMATIC_TOKEN_ASSOCIATIONS, data.automaticTokenAssociations(), arg_0 -> TokenAssociation.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)TransactionRecordSchema.PARENT_CONSENSUS_TIMESTAMP, (Object)data.parentConsensusTimestamp(), arg_0 -> Timestamp.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.ALIAS, (RandomAccessData)data.alias());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.ETHEREUM_HASH, (RandomAccessData)data.ethereumHash());
        size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)TransactionRecordSchema.PAID_STAKING_REWARDS, data.paidStakingRewards(), arg_0 -> AccountAmount.PROTOBUF.measureRecord(arg_0));
        if (data.entropy().kind() == TransactionRecord.EntropyOneOfType.PRNG_BYTES) {
            size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.PRNG_BYTES, (RandomAccessData)((RandomAccessData)data.entropy().as()));
        }
        if (data.entropy().kind() == TransactionRecord.EntropyOneOfType.PRNG_NUMBER) {
            size += ProtoWriterTools.sizeOfInteger((FieldDefinition)TransactionRecordSchema.PRNG_NUMBER, (int)((Integer)data.entropy().as()));
        }
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)TransactionRecordSchema.EVM_ADDRESS, (RandomAccessData)data.evmAddress());
    }

    public boolean fastEquals(@NonNull TransactionRecord item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private TransactionRecord parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_receipt = null;
        Bytes temp_transactionHash = Bytes.EMPTY;
        Record temp_consensusTimestamp = null;
        Record temp_transactionID = null;
        String temp_memo = "";
        long temp_transactionFee = 0L;
        OneOf temp_body = BODY_UNSET;
        Record temp_transferList = null;
        List temp_tokenTransferLists = Collections.emptyList();
        Record temp_scheduleRef = null;
        List temp_assessed_custom_fees = Collections.emptyList();
        List temp_automatic_token_associations = Collections.emptyList();
        Record temp_parent_consensus_timestamp = null;
        Bytes temp_alias = Bytes.EMPTY;
        Bytes temp_ethereum_hash = Bytes.EMPTY;
        List temp_paid_staking_rewards = Collections.emptyList();
        OneOf temp_entropy = ENTROPY_UNSET;
        Bytes temp_evm_address = Bytes.EMPTY;
        try {
            block24: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = TransactionRecordSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TransactionReceipt)TransactionReceipt.PROTOBUF.parseStrict(input) : (TransactionReceipt)TransactionReceipt.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_receipt = value;
                        continue block24;
                    }
                    case 18: {
                        Bytes value;
                        temp_transactionHash = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block24;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_consensusTimestamp = value;
                        continue block24;
                    }
                    case 34: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TransactionID)TransactionID.PROTOBUF.parseStrict(input) : (TransactionID)TransactionID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_transactionID = value;
                        continue block24;
                    }
                    case 42: {
                        String value;
                        temp_memo = value = ProtoParserTools.readString((ReadableSequentialData)input);
                        continue block24;
                    }
                    case 48: {
                        long value;
                        temp_transactionFee = value = ProtoParserTools.readUint64((ReadableSequentialData)input);
                        continue block24;
                    }
                    case 58: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractFunctionResult)ContractFunctionResult.PROTOBUF.parseStrict(input) : (ContractFunctionResult)ContractFunctionResult.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_body = new OneOf((Object)TransactionRecord.BodyOneOfType.CONTRACT_CALL_RESULT, (Object)value);
                        continue block24;
                    }
                    case 66: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractFunctionResult)ContractFunctionResult.PROTOBUF.parseStrict(input) : (ContractFunctionResult)ContractFunctionResult.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_body = new OneOf((Object)TransactionRecord.BodyOneOfType.CONTRACT_CREATE_RESULT, (Object)value);
                        continue block24;
                    }
                    case 82: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TransferList)TransferList.PROTOBUF.parseStrict(input) : (TransferList)TransferList.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_transferList = value;
                        continue block24;
                    }
                    case 90: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TokenTransferList)TokenTransferList.PROTOBUF.parseStrict(input) : (TokenTransferList)TokenTransferList.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_tokenTransferLists = ProtoParserTools.addToList(temp_tokenTransferLists, (Object)value);
                        continue block24;
                    }
                    case 98: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ScheduleID)ScheduleID.PROTOBUF.parseStrict(input) : (ScheduleID)ScheduleID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_scheduleRef = value;
                        continue block24;
                    }
                    case 106: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AssessedCustomFee)AssessedCustomFee.PROTOBUF.parseStrict(input) : (AssessedCustomFee)AssessedCustomFee.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_assessed_custom_fees = ProtoParserTools.addToList(temp_assessed_custom_fees, (Object)value);
                        continue block24;
                    }
                    case 114: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (TokenAssociation)TokenAssociation.PROTOBUF.parseStrict(input) : (TokenAssociation)TokenAssociation.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_automatic_token_associations = ProtoParserTools.addToList(temp_automatic_token_associations, (Object)value);
                        continue block24;
                    }
                    case 122: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (Timestamp)Timestamp.PROTOBUF.parseStrict(input) : (Timestamp)Timestamp.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_parent_consensus_timestamp = value;
                        continue block24;
                    }
                    case 130: {
                        Bytes value;
                        temp_alias = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block24;
                    }
                    case 138: {
                        Bytes value;
                        temp_ethereum_hash = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block24;
                    }
                    case 146: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (AccountAmount)AccountAmount.PROTOBUF.parseStrict(input) : (AccountAmount)AccountAmount.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_paid_staking_rewards = ProtoParserTools.addToList(temp_paid_staking_rewards, (Object)value);
                        continue block24;
                    }
                    case 154: {
                        Bytes value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        temp_entropy = new OneOf((Object)TransactionRecord.EntropyOneOfType.PRNG_BYTES, (Object)value);
                        continue block24;
                    }
                    case 160: {
                        int value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        temp_entropy = new OneOf((Object)TransactionRecord.EntropyOneOfType.PRNG_NUMBER, (Object)value);
                        continue block24;
                    }
                    case 170: {
                        Bytes value;
                        temp_evm_address = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block24;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new TransactionRecord((TransactionReceipt)temp_receipt, temp_transactionHash, (Timestamp)temp_consensusTimestamp, (TransactionID)temp_transactionID, temp_memo, temp_transactionFee, (OneOf<TransactionRecord.BodyOneOfType>)temp_body, (TransferList)temp_transferList, temp_tokenTransferLists, (ScheduleID)temp_scheduleRef, temp_assessed_custom_fees, temp_automatic_token_associations, (Timestamp)temp_parent_consensus_timestamp, temp_alias, temp_ethereum_hash, temp_paid_staking_rewards, (OneOf<TransactionRecord.EntropyOneOfType>)temp_entropy, temp_evm_address);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new TransactionRecord((TransactionReceipt)temp_receipt, temp_transactionHash, (Timestamp)temp_consensusTimestamp, (TransactionID)temp_transactionID, temp_memo, temp_transactionFee, (OneOf<TransactionRecord.BodyOneOfType>)temp_body, (TransferList)temp_transferList, temp_tokenTransferLists, (ScheduleID)temp_scheduleRef, temp_assessed_custom_fees, temp_automatic_token_associations, (Timestamp)temp_parent_consensus_timestamp, temp_alias, temp_ethereum_hash, temp_paid_staking_rewards, (OneOf<TransactionRecord.EntropyOneOfType>)temp_entropy, temp_evm_address);
    }
}

