/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.streams.HashAlgorithm;
import com.hedera.hapi.streams.codec.HashObjectJsonCodec;
import com.hedera.hapi.streams.codec.HashObjectProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.io.buffer.Bytes;

public record HashObject(HashAlgorithm algorithm, int length, Bytes hash) {
    public static final Codec<HashObject> PROTOBUF = new HashObjectProtoCodec();
    public static final JsonCodec<HashObject> JSON = new HashObjectJsonCodec();
    public static final HashObject DEFAULT = HashObject.newBuilder().build();

    public Builder copyBuilder() {
        return new Builder(this.algorithm, this.length, this.hash);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private HashAlgorithm algorithm = HashAlgorithm.values()[0];
        private int length = 0;
        private Bytes hash = Bytes.EMPTY;

        public Builder() {
        }

        public Builder(HashAlgorithm algorithm, int length, Bytes hash) {
            this.algorithm = algorithm;
            this.length = length;
            this.hash = hash;
        }

        public HashObject build() {
            return new HashObject(this.algorithm, this.length, this.hash);
        }

        public Builder algorithm(HashAlgorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        public Builder length(int length) {
            this.length = length;
            return this;
        }

        public Builder hash(Bytes hash) {
            this.hash = hash;
            return this;
        }
    }
}

