/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams;

import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.TransactionRecord;
import com.hedera.hapi.streams.codec.RecordStreamItemJsonCodec;
import com.hedera.hapi.streams.codec.RecordStreamItemProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record RecordStreamItem(@Nullable Transaction transaction, @Nullable TransactionRecord record) {
    public static final Codec<RecordStreamItem> PROTOBUF = new RecordStreamItemProtoCodec();
    public static final JsonCodec<RecordStreamItem> JSON = new RecordStreamItemJsonCodec();
    public static final RecordStreamItem DEFAULT = RecordStreamItem.newBuilder().build();

    public boolean hasTransaction() {
        return this.transaction != null;
    }

    public Transaction transactionOrElse(@NonNull Transaction defaultValue) {
        return this.hasTransaction() ? this.transaction : defaultValue;
    }

    @NonNull
    public Transaction transactionOrThrow() {
        return Objects.requireNonNull(this.transaction, "Field transaction is null");
    }

    public void ifTransaction(@NonNull Consumer<Transaction> ifPresent) {
        if (this.hasTransaction()) {
            ifPresent.accept(this.transaction);
        }
    }

    public boolean hasRecord() {
        return this.record != null;
    }

    public TransactionRecord recordOrElse(@NonNull TransactionRecord defaultValue) {
        return this.hasRecord() ? this.record : defaultValue;
    }

    @NonNull
    public TransactionRecord recordOrThrow() {
        return Objects.requireNonNull(this.record, "Field record is null");
    }

    public void ifRecord(@NonNull Consumer<TransactionRecord> ifPresent) {
        if (this.hasRecord()) {
            ifPresent.accept(this.record);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.transaction, this.record);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Transaction transaction = null;
        private TransactionRecord record = null;

        public Builder() {
        }

        public Builder(Transaction transaction, TransactionRecord record) {
            this.transaction = transaction;
            this.record = record;
        }

        public RecordStreamItem build() {
            return new RecordStreamItem(this.transaction, this.record);
        }

        public Builder transaction(Transaction transaction) {
            this.transaction = transaction;
            return this;
        }

        public Builder transaction(Transaction.Builder builder) {
            this.transaction = builder.build();
            return this;
        }

        public Builder record(TransactionRecord record) {
            this.record = record;
            return this;
        }

        public Builder record(TransactionRecord.Builder builder) {
            this.record = builder.build();
            return this;
        }
    }
}

