/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.streams.ContractStateChange;
import com.hedera.hapi.streams.StorageChange;
import com.hedera.hapi.streams.schema.ContractStateChangeSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class ContractStateChangeProtoCodec
implements Codec<ContractStateChange> {
    @NonNull
    public ContractStateChange parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public ContractStateChange parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull ContractStateChange data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)ContractStateChangeSchema.CONTRACT_ID, (Object)data.contractId(), (arg_0, arg_1) -> ContractID.PROTOBUF.write(arg_0, arg_1), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessageList((WritableSequentialData)out, (FieldDefinition)ContractStateChangeSchema.STORAGE_CHANGES, data.storageChanges(), (arg_0, arg_1) -> StorageChange.PROTOBUF.write(arg_0, arg_1), arg_0 -> StorageChange.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(ContractStateChange data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)ContractStateChangeSchema.CONTRACT_ID, (Object)data.contractId(), arg_0 -> ContractID.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfMessageList((FieldDefinition)ContractStateChangeSchema.STORAGE_CHANGES, data.storageChanges(), arg_0 -> StorageChange.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull ContractStateChange item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private ContractStateChange parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        Record temp_contract_id = null;
        List temp_storage_changes = Collections.emptyList();
        try {
            block6: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = ContractStateChangeSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (ContractID)ContractID.PROTOBUF.parseStrict(input) : (ContractID)ContractID.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_contract_id = value;
                        continue block6;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        Record value = strictMode ? (StorageChange)StorageChange.PROTOBUF.parseStrict(input) : (StorageChange)StorageChange.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_storage_changes = ProtoParserTools.addToList(temp_storage_changes, (Object)value);
                        continue block6;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new ContractStateChange((ContractID)temp_contract_id, temp_storage_changes);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new ContractStateChange((ContractID)temp_contract_id, temp_storage_changes);
    }
}

