/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.streams.HashAlgorithm;
import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.schema.HashObjectSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class HashObjectProtoCodec
implements Codec<HashObject> {
    @NonNull
    public HashObject parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public HashObject parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull HashObject data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)HashObjectSchema.ALGORITHM, (EnumWithProtoMetadata)data.algorithm());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)HashObjectSchema.LENGTH, (int)data.length());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)HashObjectSchema.HASH, (RandomAccessData)data.hash());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(HashObject data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfEnum((FieldDefinition)HashObjectSchema.ALGORITHM, (EnumWithProtoMetadata)data.algorithm());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)HashObjectSchema.LENGTH, (int)data.length());
        return size += ProtoWriterTools.sizeOfBytes((FieldDefinition)HashObjectSchema.HASH, (RandomAccessData)data.hash());
    }

    public boolean fastEquals(@NonNull HashObject item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private HashObject parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        HashAlgorithm temp_algorithm = HashAlgorithm.values()[0];
        int temp_length = 0;
        Bytes temp_hash = Bytes.EMPTY;
        try {
            block7: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = HashObjectSchema.getField(field);
                switch (tag) {
                    case 8: {
                        HashAlgorithm value;
                        temp_algorithm = value = HashAlgorithm.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block7;
                    }
                    case 16: {
                        int value;
                        temp_length = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block7;
                    }
                    case 26: {
                        Bytes value;
                        temp_hash = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block7;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new HashObject(temp_algorithm, temp_length, temp_hash);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new HashObject(temp_algorithm, temp_length, temp_hash);
    }
}

