/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.streams.SignatureFile;
import com.hedera.hapi.streams.SignatureObject;
import com.hedera.hapi.streams.schema.SignatureFileSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class SignatureFileProtoCodec
implements Codec<SignatureFile> {
    @NonNull
    public SignatureFile parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public SignatureFile parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull SignatureFile data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)SignatureFileSchema.FILE_SIGNATURE, (Object)data.fileSignature(), (arg_0, arg_1) -> SignatureObject.PROTOBUF.write(arg_0, arg_1), arg_0 -> SignatureObject.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)SignatureFileSchema.METADATA_SIGNATURE, (Object)data.metadataSignature(), (arg_0, arg_1) -> SignatureObject.PROTOBUF.write(arg_0, arg_1), arg_0 -> SignatureObject.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(SignatureFile data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)SignatureFileSchema.FILE_SIGNATURE, (Object)data.fileSignature(), arg_0 -> SignatureObject.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)SignatureFileSchema.METADATA_SIGNATURE, (Object)data.metadataSignature(), arg_0 -> SignatureObject.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull SignatureFile item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private SignatureFile parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        SignatureObject temp_file_signature = null;
        SignatureObject temp_metadata_signature = null;
        try {
            block6: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = SignatureFileSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        SignatureObject value = strictMode ? (SignatureObject)SignatureObject.PROTOBUF.parseStrict(input) : (SignatureObject)SignatureObject.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_file_signature = value;
                        continue block6;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        SignatureObject value = strictMode ? (SignatureObject)SignatureObject.PROTOBUF.parseStrict(input) : (SignatureObject)SignatureObject.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_metadata_signature = value;
                        continue block6;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new SignatureFile(temp_file_signature, temp_metadata_signature);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new SignatureFile(temp_file_signature, temp_metadata_signature);
    }
}

