/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.streams.codec;

import com.hedera.hapi.streams.HashObject;
import com.hedera.hapi.streams.SignatureObject;
import com.hedera.hapi.streams.SignatureType;
import com.hedera.hapi.streams.schema.SignatureObjectSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.io.buffer.RandomAccessData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class SignatureObjectProtoCodec
implements Codec<SignatureObject> {
    @NonNull
    public SignatureObject parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public SignatureObject parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull SignatureObject data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)SignatureObjectSchema.TYPE, (EnumWithProtoMetadata)data.type());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)SignatureObjectSchema.LENGTH, (int)data.length());
        ProtoWriterTools.writeInteger((WritableSequentialData)out, (FieldDefinition)SignatureObjectSchema.CHECKSUM, (int)data.checksum());
        ProtoWriterTools.writeBytes((WritableSequentialData)out, (FieldDefinition)SignatureObjectSchema.SIGNATURE, (RandomAccessData)data.signature());
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)SignatureObjectSchema.HASH_OBJECT, (Object)data.hashObject(), (arg_0, arg_1) -> HashObject.PROTOBUF.write(arg_0, arg_1), arg_0 -> HashObject.PROTOBUF.measureRecord(arg_0));
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(SignatureObject data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfEnum((FieldDefinition)SignatureObjectSchema.TYPE, (EnumWithProtoMetadata)data.type());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)SignatureObjectSchema.LENGTH, (int)data.length());
        size += ProtoWriterTools.sizeOfInteger((FieldDefinition)SignatureObjectSchema.CHECKSUM, (int)data.checksum());
        size += ProtoWriterTools.sizeOfBytes((FieldDefinition)SignatureObjectSchema.SIGNATURE, (RandomAccessData)data.signature());
        return size += ProtoWriterTools.sizeOfMessage((FieldDefinition)SignatureObjectSchema.HASH_OBJECT, (Object)data.hashObject(), arg_0 -> HashObject.PROTOBUF.measureRecord(arg_0));
    }

    public boolean fastEquals(@NonNull SignatureObject item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private SignatureObject parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        SignatureType temp_type = SignatureType.values()[0];
        int temp_length = 0;
        int temp_checksum = 0;
        Bytes temp_signature = Bytes.EMPTY;
        HashObject temp_hash_object = null;
        try {
            block9: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = SignatureObjectSchema.getField(field);
                switch (tag) {
                    case 8: {
                        SignatureType value;
                        temp_type = value = SignatureType.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block9;
                    }
                    case 16: {
                        int value;
                        temp_length = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block9;
                    }
                    case 24: {
                        int value;
                        temp_checksum = value = ProtoParserTools.readInt32((ReadableSequentialData)input);
                        continue block9;
                    }
                    case 34: {
                        Bytes value;
                        temp_signature = value = ProtoParserTools.readBytes((ReadableSequentialData)input);
                        continue block9;
                    }
                    case 42: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        HashObject value = strictMode ? (HashObject)HashObject.PROTOBUF.parseStrict(input) : (HashObject)HashObject.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_hash_object = value;
                        continue block9;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new SignatureObject(temp_type, temp_length, temp_checksum, temp_signature, temp_hash_object);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new SignatureObject(temp_type, temp_length, temp_checksum, temp_signature, temp_hash_object);
    }
}

