/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.codec.AccountAmountJsonCodec;
import com.hedera.hapi.node.base.codec.AccountAmountProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record AccountAmount(@Nullable AccountID accountID, long amount, boolean isApproval) {
    public static final Codec<AccountAmount> PROTOBUF = new AccountAmountProtoCodec();
    public static final JsonCodec<AccountAmount> JSON = new AccountAmountJsonCodec();
    public static final AccountAmount DEFAULT = AccountAmount.newBuilder().build();

    public boolean hasAccountID() {
        return this.accountID != null;
    }

    public AccountID accountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasAccountID() ? this.accountID : defaultValue;
    }

    @NonNull
    public AccountID accountIDOrThrow() {
        return Objects.requireNonNull(this.accountID, "Field accountID is null");
    }

    public void ifAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasAccountID()) {
            ifPresent.accept(this.accountID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.accountID, this.amount, this.isApproval);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private AccountID accountID = null;
        private long amount = 0L;
        private boolean isApproval = false;

        public Builder() {
        }

        public Builder(AccountID accountID, long amount, boolean isApproval) {
            this.accountID = accountID;
            this.amount = amount;
            this.isApproval = isApproval;
        }

        public AccountAmount build() {
            return new AccountAmount(this.accountID, this.amount, this.isApproval);
        }

        public Builder accountID(AccountID accountID) {
            this.accountID = accountID;
            return this;
        }

        public Builder accountID(AccountID.Builder builder) {
            this.accountID = builder.build();
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder isApproval(boolean isApproval) {
            this.isApproval = isApproval;
            return this;
        }
    }
}

