/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.TimestampSeconds;
import com.hedera.hapi.node.base.TransactionFeeSchedule;
import com.hedera.hapi.node.base.codec.FeeScheduleJsonCodec;
import com.hedera.hapi.node.base.codec.FeeScheduleProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record FeeSchedule(@Nullable List<TransactionFeeSchedule> transactionFeeSchedule, @Nullable TimestampSeconds expiryTime) {
    public static final Codec<FeeSchedule> PROTOBUF = new FeeScheduleProtoCodec();
    public static final JsonCodec<FeeSchedule> JSON = new FeeScheduleJsonCodec();
    public static final FeeSchedule DEFAULT = FeeSchedule.newBuilder().build();

    public boolean hasTransactionFeeSchedule() {
        return this.transactionFeeSchedule != null;
    }

    public List<TransactionFeeSchedule> transactionFeeScheduleOrElse(@NonNull List<TransactionFeeSchedule> defaultValue) {
        return this.hasTransactionFeeSchedule() ? this.transactionFeeSchedule : defaultValue;
    }

    @NonNull
    public List<TransactionFeeSchedule> transactionFeeScheduleOrThrow() {
        return Objects.requireNonNull(this.transactionFeeSchedule, "Field transactionFeeSchedule is null");
    }

    public void ifTransactionFeeSchedule(@NonNull Consumer<List<TransactionFeeSchedule>> ifPresent) {
        if (this.hasTransactionFeeSchedule()) {
            ifPresent.accept(this.transactionFeeSchedule);
        }
    }

    public boolean hasExpiryTime() {
        return this.expiryTime != null;
    }

    public TimestampSeconds expiryTimeOrElse(@NonNull TimestampSeconds defaultValue) {
        return this.hasExpiryTime() ? this.expiryTime : defaultValue;
    }

    @NonNull
    public TimestampSeconds expiryTimeOrThrow() {
        return Objects.requireNonNull(this.expiryTime, "Field expiryTime is null");
    }

    public void ifExpiryTime(@NonNull Consumer<TimestampSeconds> ifPresent) {
        if (this.hasExpiryTime()) {
            ifPresent.accept(this.expiryTime);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.transactionFeeSchedule, this.expiryTime);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private List<TransactionFeeSchedule> transactionFeeSchedule = Collections.emptyList();
        private TimestampSeconds expiryTime = null;

        public Builder() {
        }

        public Builder(List<TransactionFeeSchedule> transactionFeeSchedule, TimestampSeconds expiryTime) {
            this.transactionFeeSchedule = transactionFeeSchedule;
            this.expiryTime = expiryTime;
        }

        public FeeSchedule build() {
            return new FeeSchedule(this.transactionFeeSchedule, this.expiryTime);
        }

        public Builder transactionFeeSchedule(List<TransactionFeeSchedule> transactionFeeSchedule) {
            this.transactionFeeSchedule = transactionFeeSchedule;
            return this;
        }

        public Builder transactionFeeSchedule(TransactionFeeSchedule ... values) {
            this.transactionFeeSchedule = List.of(values);
            return this;
        }

        public Builder expiryTime(TimestampSeconds expiryTime) {
            this.expiryTime = expiryTime;
            return this;
        }

        public Builder expiryTime(TimestampSeconds.Builder builder) {
            this.expiryTime = builder.build();
            return this;
        }
    }
}

