/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.codec.KeyListJsonCodec;
import com.hedera.hapi.node.base.codec.KeyListProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record KeyList(@Nullable List<Key> keys) {
    public static final Codec<KeyList> PROTOBUF = new KeyListProtoCodec();
    public static final JsonCodec<KeyList> JSON = new KeyListJsonCodec();
    public static final KeyList DEFAULT = KeyList.newBuilder().build();

    public boolean hasKeys() {
        return this.keys != null;
    }

    public List<Key> keysOrElse(@NonNull List<Key> defaultValue) {
        return this.hasKeys() ? this.keys : defaultValue;
    }

    @NonNull
    public List<Key> keysOrThrow() {
        return Objects.requireNonNull(this.keys, "Field keys is null");
    }

    public void ifKeys(@NonNull Consumer<List<Key>> ifPresent) {
        if (this.hasKeys()) {
            ifPresent.accept(this.keys);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.keys);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private List<Key> keys = Collections.emptyList();

        public Builder() {
        }

        public Builder(List<Key> keys) {
            this.keys = keys;
        }

        public KeyList build() {
            return new KeyList(this.keys);
        }

        public Builder keys(List<Key> keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(Key ... values) {
            this.keys = List.of(values);
            return this;
        }
    }
}

