/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.KeyList;
import com.hedera.hapi.node.base.codec.ThresholdKeyJsonCodec;
import com.hedera.hapi.node.base.codec.ThresholdKeyProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record ThresholdKey(int threshold, @Nullable KeyList keys) {
    public static final Codec<ThresholdKey> PROTOBUF = new ThresholdKeyProtoCodec();
    public static final JsonCodec<ThresholdKey> JSON = new ThresholdKeyJsonCodec();
    public static final ThresholdKey DEFAULT = ThresholdKey.newBuilder().build();

    public boolean hasKeys() {
        return this.keys != null;
    }

    public KeyList keysOrElse(@NonNull KeyList defaultValue) {
        return this.hasKeys() ? this.keys : defaultValue;
    }

    @NonNull
    public KeyList keysOrThrow() {
        return Objects.requireNonNull(this.keys, "Field keys is null");
    }

    public void ifKeys(@NonNull Consumer<KeyList> ifPresent) {
        if (this.hasKeys()) {
            ifPresent.accept(this.keys);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.threshold, this.keys);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private int threshold = 0;
        private KeyList keys = null;

        public Builder() {
        }

        public Builder(int threshold, KeyList keys) {
            this.threshold = threshold;
            this.keys = keys;
        }

        public ThresholdKey build() {
            return new ThresholdKey(this.threshold, this.keys);
        }

        public Builder threshold(int threshold) {
            this.threshold = threshold;
            return this;
        }

        public Builder keys(KeyList keys) {
            this.keys = keys;
            return this;
        }

        public Builder keys(KeyList.Builder builder) {
            this.keys = builder.build();
            return this;
        }
    }
}

