/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.codec.TokenBalanceJsonCodec;
import com.hedera.hapi.node.base.codec.TokenBalanceProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenBalance(@Nullable TokenID tokenId, long balance, int decimals) {
    public static final Codec<TokenBalance> PROTOBUF = new TokenBalanceProtoCodec();
    public static final JsonCodec<TokenBalance> JSON = new TokenBalanceJsonCodec();
    public static final TokenBalance DEFAULT = TokenBalance.newBuilder().build();

    public boolean hasTokenId() {
        return this.tokenId != null;
    }

    public TokenID tokenIdOrElse(@NonNull TokenID defaultValue) {
        return this.hasTokenId() ? this.tokenId : defaultValue;
    }

    @NonNull
    public TokenID tokenIdOrThrow() {
        return Objects.requireNonNull(this.tokenId, "Field tokenId is null");
    }

    public void ifTokenId(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasTokenId()) {
            ifPresent.accept(this.tokenId);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.tokenId, this.balance, this.decimals);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID tokenId = null;
        private long balance = 0L;
        private int decimals = 0;

        public Builder() {
        }

        public Builder(TokenID tokenId, long balance, int decimals) {
            this.tokenId = tokenId;
            this.balance = balance;
            this.decimals = decimals;
        }

        public TokenBalance build() {
            return new TokenBalance(this.tokenId, this.balance, this.decimals);
        }

        public Builder tokenId(TokenID tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public Builder tokenId(TokenID.Builder builder) {
            this.tokenId = builder.build();
            return this;
        }

        public Builder balance(long balance) {
            this.balance = balance;
            return this;
        }

        public Builder decimals(int decimals) {
            this.decimals = decimals;
            return this;
        }
    }
}

