/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.codec.TokenTransferListJsonCodec;
import com.hedera.hapi.node.base.codec.TokenTransferListProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TokenTransferList(@Nullable TokenID token, @Nullable List<AccountAmount> transfers, @Nullable List<NftTransfer> nftTransfers, @Nullable Integer expectedDecimals) {
    public static final Codec<TokenTransferList> PROTOBUF = new TokenTransferListProtoCodec();
    public static final JsonCodec<TokenTransferList> JSON = new TokenTransferListJsonCodec();
    public static final TokenTransferList DEFAULT = TokenTransferList.newBuilder().build();

    public boolean hasToken() {
        return this.token != null;
    }

    public TokenID tokenOrElse(@NonNull TokenID defaultValue) {
        return this.hasToken() ? this.token : defaultValue;
    }

    @NonNull
    public TokenID tokenOrThrow() {
        return Objects.requireNonNull(this.token, "Field token is null");
    }

    public void ifToken(@NonNull Consumer<TokenID> ifPresent) {
        if (this.hasToken()) {
            ifPresent.accept(this.token);
        }
    }

    public boolean hasTransfers() {
        return this.transfers != null;
    }

    public List<AccountAmount> transfersOrElse(@NonNull List<AccountAmount> defaultValue) {
        return this.hasTransfers() ? this.transfers : defaultValue;
    }

    @NonNull
    public List<AccountAmount> transfersOrThrow() {
        return Objects.requireNonNull(this.transfers, "Field transfers is null");
    }

    public void ifTransfers(@NonNull Consumer<List<AccountAmount>> ifPresent) {
        if (this.hasTransfers()) {
            ifPresent.accept(this.transfers);
        }
    }

    public boolean hasNftTransfers() {
        return this.nftTransfers != null;
    }

    public List<NftTransfer> nftTransfersOrElse(@NonNull List<NftTransfer> defaultValue) {
        return this.hasNftTransfers() ? this.nftTransfers : defaultValue;
    }

    @NonNull
    public List<NftTransfer> nftTransfersOrThrow() {
        return Objects.requireNonNull(this.nftTransfers, "Field nftTransfers is null");
    }

    public void ifNftTransfers(@NonNull Consumer<List<NftTransfer>> ifPresent) {
        if (this.hasNftTransfers()) {
            ifPresent.accept(this.nftTransfers);
        }
    }

    public boolean hasExpectedDecimals() {
        return this.expectedDecimals != null;
    }

    public Integer expectedDecimalsOrElse(@NonNull Integer defaultValue) {
        return this.hasExpectedDecimals() ? this.expectedDecimals : defaultValue;
    }

    @NonNull
    public Integer expectedDecimalsOrThrow() {
        return Objects.requireNonNull(this.expectedDecimals, "Field expectedDecimals is null");
    }

    public void ifExpectedDecimals(@NonNull Consumer<Integer> ifPresent) {
        if (this.hasExpectedDecimals()) {
            ifPresent.accept(this.expectedDecimals);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.token, this.transfers, this.nftTransfers, this.expectedDecimals);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private TokenID token = null;
        private List<AccountAmount> transfers = Collections.emptyList();
        private List<NftTransfer> nftTransfers = Collections.emptyList();
        private Integer expectedDecimals = null;

        public Builder() {
        }

        public Builder(TokenID token, List<AccountAmount> transfers, List<NftTransfer> nftTransfers, Integer expectedDecimals) {
            this.token = token;
            this.transfers = transfers;
            this.nftTransfers = nftTransfers;
            this.expectedDecimals = expectedDecimals;
        }

        public TokenTransferList build() {
            return new TokenTransferList(this.token, this.transfers, this.nftTransfers, this.expectedDecimals);
        }

        public Builder token(TokenID token) {
            this.token = token;
            return this;
        }

        public Builder token(TokenID.Builder builder) {
            this.token = builder.build();
            return this;
        }

        public Builder transfers(List<AccountAmount> transfers) {
            this.transfers = transfers;
            return this;
        }

        public Builder transfers(AccountAmount ... values) {
            this.transfers = List.of(values);
            return this;
        }

        public Builder nftTransfers(List<NftTransfer> nftTransfers) {
            this.nftTransfers = nftTransfers;
            return this;
        }

        public Builder nftTransfers(NftTransfer ... values) {
            this.nftTransfers = List.of(values);
            return this;
        }

        public Builder expectedDecimals(Integer expectedDecimals) {
            this.expectedDecimals = expectedDecimals;
            return this;
        }
    }
}

