/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.codec.TransferListJsonCodec;
import com.hedera.hapi.node.base.codec.TransferListProtoCodec;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.JsonCodec;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public record TransferList(@Nullable List<AccountAmount> accountAmounts) {
    public static final Codec<TransferList> PROTOBUF = new TransferListProtoCodec();
    public static final JsonCodec<TransferList> JSON = new TransferListJsonCodec();
    public static final TransferList DEFAULT = TransferList.newBuilder().build();

    public boolean hasAccountAmounts() {
        return this.accountAmounts != null;
    }

    public List<AccountAmount> accountAmountsOrElse(@NonNull List<AccountAmount> defaultValue) {
        return this.hasAccountAmounts() ? this.accountAmounts : defaultValue;
    }

    @NonNull
    public List<AccountAmount> accountAmountsOrThrow() {
        return Objects.requireNonNull(this.accountAmounts, "Field accountAmounts is null");
    }

    public void ifAccountAmounts(@NonNull Consumer<List<AccountAmount>> ifPresent) {
        if (this.hasAccountAmounts()) {
            ifPresent.accept(this.accountAmounts);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.accountAmounts);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private List<AccountAmount> accountAmounts = Collections.emptyList();

        public Builder() {
        }

        public Builder(List<AccountAmount> accountAmounts) {
            this.accountAmounts = accountAmounts;
        }

        public TransferList build() {
            return new TransferList(this.accountAmounts);
        }

        public Builder accountAmounts(List<AccountAmount> accountAmounts) {
            this.accountAmounts = accountAmounts;
            return this;
        }

        public Builder accountAmounts(AccountAmount ... values) {
            this.accountAmounts = List.of(values);
            return this;
        }
    }
}

