/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.OneOf;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.util.ArrayList;

public final class AccountIDJsonCodec
implements JsonCodec<AccountID> {
    public static final OneOf<AccountID.AccountOneOfType> ACCOUNT_UNSET = new OneOf((Object)AccountID.AccountOneOfType.UNSET, null);

    @NonNull
    public AccountID parse(@Nullable JSONParser.ObjContext root, boolean strictMode) throws IOException {
        long temp_shardNum = 0L;
        long temp_realmNum = 0L;
        OneOf temp_account = ACCOUNT_UNSET;
        block12: for (JSONParser.PairContext kvPair : root.pair()) {
            switch (kvPair.STRING().getText()) {
                case "shardNum": {
                    temp_shardNum = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block12;
                }
                case "realmNum": {
                    temp_realmNum = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                    continue block12;
                }
                case "accountNum": {
                    temp_account = new OneOf((Object)AccountID.AccountOneOfType.ACCOUNT_NUM, (Object)JsonTools.parseLong((JSONParser.ValueContext)kvPair.value()));
                    continue block12;
                }
                case "alias": {
                    temp_account = new OneOf((Object)AccountID.AccountOneOfType.ALIAS, (Object)Bytes.fromBase64((String)kvPair.value().STRING().getText()));
                    continue block12;
                }
            }
            if (!strictMode) continue;
            throw new UnknownFieldException(kvPair.STRING().getText());
        }
        return new AccountID(temp_shardNum, temp_realmNum, temp_account);
    }

    public String toJSON(@NonNull AccountID data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.shardNum() != 0L) {
            fieldLines.add(JsonTools.field((String)"shardNum", (long)data.shardNum()));
        }
        if (data.realmNum() != 0L) {
            fieldLines.add(JsonTools.field((String)"realmNum", (long)data.realmNum()));
        }
        if (data.account().kind() == AccountID.AccountOneOfType.ACCOUNT_NUM) {
            fieldLines.add(JsonTools.field((String)"accountNum", (long)data.accountNum()));
        }
        if (data.account().kind() == AccountID.AccountOneOfType.ALIAS) {
            fieldLines.add(JsonTools.field((String)"alias", (Bytes)data.alias()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

