/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base.codec;

import com.hedera.hapi.node.base.FeeComponents;
import com.hedera.hapi.node.base.FeeData;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.schema.FeeDataSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.ProtoParserTools;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.stream.EOFException;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;

public final class FeeDataProtoCodec
implements Codec<FeeData> {
    @NonNull
    public FeeData parse(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, false);
    }

    @NonNull
    public FeeData parseStrict(@NonNull ReadableSequentialData input) throws IOException {
        return this.parseInternal(input, true);
    }

    public void write(@NonNull FeeData data, @NonNull WritableSequentialData out) throws IOException {
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FeeDataSchema.NODEDATA, (Object)data.nodedata(), (arg_0, arg_1) -> FeeComponents.PROTOBUF.write(arg_0, arg_1), arg_0 -> FeeComponents.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FeeDataSchema.NETWORKDATA, (Object)data.networkdata(), (arg_0, arg_1) -> FeeComponents.PROTOBUF.write(arg_0, arg_1), arg_0 -> FeeComponents.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeMessage((WritableSequentialData)out, (FieldDefinition)FeeDataSchema.SERVICEDATA, (Object)data.servicedata(), (arg_0, arg_1) -> FeeComponents.PROTOBUF.write(arg_0, arg_1), arg_0 -> FeeComponents.PROTOBUF.measureRecord(arg_0));
        ProtoWriterTools.writeEnum((WritableSequentialData)out, (FieldDefinition)FeeDataSchema.SUB_TYPE, (EnumWithProtoMetadata)data.subType());
    }

    public int measure(@NonNull ReadableSequentialData input) throws IOException {
        long start = input.position();
        this.parse(input);
        long end = input.position();
        return (int)(end - start);
    }

    public int measureRecord(FeeData data) {
        int size = 0;
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FeeDataSchema.NODEDATA, (Object)data.nodedata(), arg_0 -> FeeComponents.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FeeDataSchema.NETWORKDATA, (Object)data.networkdata(), arg_0 -> FeeComponents.PROTOBUF.measureRecord(arg_0));
        size += ProtoWriterTools.sizeOfMessage((FieldDefinition)FeeDataSchema.SERVICEDATA, (Object)data.servicedata(), arg_0 -> FeeComponents.PROTOBUF.measureRecord(arg_0));
        return size += ProtoWriterTools.sizeOfEnum((FieldDefinition)FeeDataSchema.SUB_TYPE, (EnumWithProtoMetadata)data.subType());
    }

    public boolean fastEquals(@NonNull FeeData item, @NonNull ReadableSequentialData input) throws IOException {
        return item.equals(this.parse(input));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NonNull
    private FeeData parseInternal(@NonNull ReadableSequentialData input, boolean strictMode) throws IOException {
        FeeComponents temp_nodedata = null;
        FeeComponents temp_networkdata = null;
        FeeComponents temp_servicedata = null;
        SubType temp_subType = SubType.values()[0];
        try {
            block8: while (input.hasRemaining()) {
                int tag = input.readVarInt(false);
                int field = tag >>> 3;
                FieldDefinition f = FeeDataSchema.getField(field);
                switch (tag) {
                    case 10: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        FeeComponents value = strictMode ? (FeeComponents)FeeComponents.PROTOBUF.parseStrict(input) : (FeeComponents)FeeComponents.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_nodedata = value;
                        continue block8;
                    }
                    case 18: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        FeeComponents value = strictMode ? (FeeComponents)FeeComponents.PROTOBUF.parseStrict(input) : (FeeComponents)FeeComponents.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_networkdata = value;
                        continue block8;
                    }
                    case 26: {
                        int messageLength = input.readVarInt(false);
                        long limitBefore = input.limit();
                        input.limit(input.position() + (long)messageLength);
                        FeeComponents value = strictMode ? (FeeComponents)FeeComponents.PROTOBUF.parseStrict(input) : (FeeComponents)FeeComponents.PROTOBUF.parse(input);
                        input.limit(limitBefore);
                        temp_servicedata = value;
                        continue block8;
                    }
                    case 32: {
                        SubType value;
                        temp_subType = value = SubType.fromProtobufOrdinal(ProtoParserTools.readEnum((ReadableSequentialData)input));
                        continue block8;
                    }
                }
                int wireType = tag & 7;
                if (field == 0) {
                    throw new IOException("Bad protobuf encoding. We read a field value of " + field);
                }
                if (wireType > 5) {
                    throw new IOException("Cannot understand wire_type of " + wireType);
                }
                if (f != null) throw new IOException("Bad tag [" + tag + "], field [" + field + "] wireType [" + wireType + "]");
                if (strictMode) {
                    throw new UnknownFieldException(field);
                }
                ProtoParserTools.skipField((ReadableSequentialData)input, (int)wireType);
            }
            return new FeeData(temp_nodedata, temp_networkdata, temp_servicedata, temp_subType);
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        return new FeeData(temp_nodedata, temp_networkdata, temp_servicedata, temp_subType);
    }
}

